/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.adapter.LocalScopeMethodVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.tree.AbstractInsnNode;
import org.jboss.byteman.objectweb.asm.tree.InsnList;
import org.jboss.byteman.objectweb.asm.tree.LabelNode;
import org.jboss.byteman.objectweb.asm.tree.LocalVariableNode;

public class BMInsnList
extends InsnList {
    List localvariables;

    public BMInsnList(List localVariables) {
        this.localvariables = localVariables;
    }

    @Override
    public void accept(MethodVisitor mv) {
        LocalScopeMethodVisitor lsmv = (LocalScopeMethodVisitor)((Object)mv);
        HashMap<Label, LinkedList<LocalVariableNode>> localStarts = new HashMap<Label, LinkedList<LocalVariableNode>>();
        HashMap<Label, LinkedList<LocalVariableNode>> localEnds = new HashMap<Label, LinkedList<LocalVariableNode>>();
        for (LocalVariableNode local : this.localvariables) {
            Label label = local.start.getLabel();
            LinkedList<LocalVariableNode> locals = (LinkedList<LocalVariableNode>)localStarts.get(label);
            if (locals == null) {
                locals = new LinkedList<LocalVariableNode>();
                localStarts.put(label, locals);
            }
            locals.addLast(local);
            label = local.end.getLabel();
            locals = (LinkedList<LocalVariableNode>)localEnds.get(label);
            if (locals == null) {
                locals = new LinkedList<LocalVariableNode>();
                localEnds.put(label, locals);
            }
            locals.addLast(local);
        }
        for (AbstractInsnNode insn = this.getFirst(); insn != null; insn = insn.getNext()) {
            insn.accept(mv);
            if (insn.getType() != 8) continue;
            LabelNode labelNode = (LabelNode)insn;
            Label label = labelNode.getLabel();
            List localStart = (List)localStarts.get(label);
            List localEnd = (List)localEnds.get(label);
            if (localStart != null) {
                for (LocalVariableNode local : localStart) {
                    lsmv.visitLocalScopeStart(local.name, local.desc, local.signature, local.index, label.getOffset());
                }
            }
            if (localEnd == null) continue;
            for (LocalVariableNode local : localEnd) {
                lsmv.visitLocalScopeEnd(local.name, local.desc, local.signature, local.index, label.getOffset());
            }
        }
    }
}

