/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.synchronization;

import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.rule.exception.ExecuteException;

public class Joiner {
    private List<Thread> children;
    private int max;
    private Thread parent;

    public Joiner(int max) {
        this.max = max;
        this.children = new LinkedList<Thread>();
        this.parent = null;
    }

    public int getMax() {
        return this.max;
    }

    public synchronized Status addChild(Thread thread) {
        if (this.children.contains(thread)) {
            return Status.DUPLICATE;
        }
        int size = this.children.size();
        if (size == this.max) {
            return Status.EXCESS;
        }
        this.children.add(thread);
        if (++size == this.max) {
            if (this.parent == null) {
                return Status.FILLED;
            }
            this.notifyAll();
            return Status.DONE;
        }
        return Status.ADDED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinChildren(Thread thread, long millis) {
        long target_time = System.currentTimeMillis() + millis;
        Joiner joiner = this;
        synchronized (joiner) {
            if (this.parent != null) {
                return false;
            }
            this.parent = thread;
            while (this.children.size() < this.max) {
                try {
                    if (millis <= 0L) {
                        this.wait();
                        continue;
                    }
                    long wait_time = target_time - System.currentTimeMillis();
                    if (wait_time > 0L) {
                        this.wait(wait_time);
                        continue;
                    }
                    throw new ExecuteException("timeout occurred in joinWait");
                }
                catch (InterruptedException e) {
                }
            }
        }
        for (int i = 0; i < this.max; ++i) {
            Thread child = this.children.get(i);
            try {
                if (millis <= 0L) {
                    child.join();
                    continue;
                }
                long wait_time = target_time - System.currentTimeMillis();
                if (wait_time > 0L) {
                    child.join(wait_time);
                    continue;
                }
                throw new ExecuteException("timeout occurred in joinWait");
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return true;
    }

    public static enum Status {
        DUPLICATE,
        EXCESS,
        ADDED,
        FILLED,
        DONE;

    }
}

