/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.client.collector.internal.FragmentBuilder;

public class FragmentManager {
    private static final Logger log = Logger.getLogger(FragmentManager.class.getName());
    private ThreadLocal<FragmentBuilder> builders = new ThreadLocal();
    private AtomicInteger threadCounter = new AtomicInteger();
    private Set<String> threadNames = new HashSet<String>();

    protected int getThreadCounter() {
        return this.threadCounter.get();
    }

    public boolean hasFragmentBuilder() {
        return this.builders.get() != null;
    }

    public FragmentBuilder getFragmentBuilder() {
        FragmentBuilder builder = this.builders.get();
        if (builder == null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Creating new FragmentBuilder");
            }
            builder = new FragmentBuilder();
            this.builders.set(builder);
            int currentCount = this.threadCounter.incrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Associate Thread with FragmentBuilder(1): current thread count=" + currentCount);
                this.threadNames.add(Thread.currentThread().getName());
            }
        }
        return builder;
    }

    public void setFragmentBuilder(FragmentBuilder builder) {
        FragmentBuilder currentBuilder = this.builders.get();
        if (currentBuilder == null && builder != null) {
            int currentCount = this.threadCounter.incrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Associate Thread with FragmentBuilder(2): current thread count=" + currentCount);
                this.threadNames.add(Thread.currentThread().getName());
            }
        } else if (currentBuilder != null && builder == null) {
            int currentCount = this.threadCounter.decrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Disassociate Thread from FragmentBuilder(2): current thread count=" + currentCount);
                this.threadNames.remove(Thread.currentThread().getName());
            }
        }
        this.builders.set(builder);
    }

    public void clear() {
        int currentCount = this.threadCounter.decrementAndGet();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Clear: Disassociate Thread from FragmentBuilder(1): current thread count=" + currentCount);
            this.threadNames.remove(Thread.currentThread().getName());
        }
        this.builders.remove();
    }

    public void diagnostics() {
        log.finest("Thread count = " + this.threadCounter);
        if (this.threadCounter.get() > 0) {
            log.finest("Thread names:");
            for (String name : this.threadNames) {
                log.finest("\t" + name);
            }
        }
    }
}

