/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.communicationdetails;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.events.CommunicationDetails;
import org.hawkular.btm.processor.communicationdetails.ProducerInfo;
import org.hawkular.btm.server.api.task.AbstractProcessor;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public class CommunicationDetailsDeriver
extends AbstractProcessor<BusinessTransaction, CommunicationDetails> {
    protected static final String CLIENT_PREFIX = "[client]";
    private static final Logger log = Logger.getLogger(CommunicationDetailsDeriver.class.getName());
    @Resource(lookup="java:jboss/infinispan/BTM")
    private CacheContainer container;
    private Cache<String, ProducerInfo> producerInfo;

    @PostConstruct
    public void init() {
        this.producerInfo = this.container.getCache("producerinfo");
    }

    protected void setProducerInfoCache(Cache<String, ProducerInfo> cache) {
        this.producerInfo = cache;
    }

    protected Cache<String, ProducerInfo> getProducerinfoCache() {
        return this.producerInfo;
    }

    public void initialise(List<BusinessTransaction> items) {
        for (int i = 0; i < items.size(); ++i) {
            String originUri = null;
            BusinessTransaction btxn = items.get(i);
            for (int j = 0; j < btxn.getNodes().size(); ++j) {
                Node node = (Node)btxn.getNodes().get(j);
                originUri = this.initialiseNode(btxn, originUri, node);
            }
        }
    }

    protected String initialiseNode(BusinessTransaction btxn, String originUri, Node node) {
        block6: {
            block5: {
                if (node.getClass() != Producer.class) break block5;
                Producer producer = (Producer)node;
                if (originUri == null) {
                    originUri = CLIENT_PREFIX + producer.getUri();
                }
                long diffns = producer.getBaseTime() - ((Node)btxn.getNodes().get(0)).getBaseTime();
                long diffms = TimeUnit.MILLISECONDS.convert(diffns, TimeUnit.NANOSECONDS);
                long timestamp = btxn.getStartTime() + diffms;
                List cids = producer.getCorrelationIds(CorrelationIdentifier.Scope.Interaction);
                if (cids.isEmpty()) break block6;
                for (int i = 0; i < cids.size(); ++i) {
                    ProducerInfo pi = new ProducerInfo();
                    pi.setOriginUri(originUri);
                    pi.setTimestamp(timestamp);
                    pi.setDuration(producer.getDuration());
                    pi.setFragmentId(btxn.getId());
                    pi.setHostName(btxn.getHostName());
                    pi.setHostAddress(btxn.getHostAddress());
                    this.producerInfo.put((Object)((CorrelationIdentifier)cids.get(i)).getValue(), (Object)pi, 1L, TimeUnit.MINUTES);
                }
                break block6;
            }
            if (node instanceof ContainerNode) {
                if (originUri == null && node.getClass() == Consumer.class) {
                    originUri = node.getUri();
                }
                for (int j = 0; j < ((ContainerNode)node).getNodes().size(); ++j) {
                    originUri = this.initialiseNode(btxn, originUri, (Node)((ContainerNode)node).getNodes().get(j));
                }
            }
        }
        return originUri;
    }

    public boolean isMultiple() {
        return false;
    }

    public CommunicationDetails processSingle(BusinessTransaction item) throws Exception {
        Consumer consumer;
        List cids;
        CommunicationDetails ret = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derive communication details for business transaction fragment: " + item);
        }
        if (item.getNodes().size() == 1 && ((Node)item.getNodes().get(0)).getClass() == Consumer.class && !(cids = (consumer = (Consumer)item.getNodes().get(0)).getCorrelationIds(CorrelationIdentifier.Scope.Interaction)).isEmpty()) {
            for (int i = 0; ret == null && i < cids.size(); ++i) {
                String id = ((CorrelationIdentifier)cids.get(i)).getValue();
                ProducerInfo pi = (ProducerInfo)this.producerInfo.get((Object)id);
                if (pi == null) continue;
                ret = new CommunicationDetails();
                ret.setId(id);
                ret.setBusinessTransaction(item.getName());
                ret.setUri(consumer.getUri());
                double diff = pi.getDuration() - (double)consumer.getDuration();
                if (diff > 0.0) {
                    ret.setLatency(diff / 2.0);
                } else if (diff < 0.0) {
                    log.warning("Negative latency for consumer = " + consumer);
                }
                ret.setProducerDuration(pi.getDuration());
                ret.setConsumerDuration((double)consumer.getDuration());
                ret.setOriginUri(pi.getOriginUri());
                ret.setProperties(item.getProperties());
                ret.setSourceFragmentId(pi.getFragmentId());
                ret.setSourceHostName(pi.getHostName());
                ret.setSourceHostAddress(pi.getHostAddress());
                ret.setTargetFragmentId(item.getId());
                ret.setTargetHostName(item.getHostName());
                ret.setTargetHostAddress(item.getHostAddress());
                ret.setTimestamp(pi.getTimestamp());
                long latencyms = TimeUnit.MILLISECONDS.convert((long)ret.getLatency(), TimeUnit.NANOSECONDS);
                long timestampOffset = item.getStartTime() - pi.getTimestamp() - latencyms;
                ret.setTimestampOffset(timestampOffset);
            }
            if (ret == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Producer information not available");
                }
                throw new RuntimeException("Producer information not available");
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derived communication details: " + ret);
        }
        return ret;
    }

    public List<CommunicationDetails> processMultiple(BusinessTransaction item) throws Exception {
        return null;
    }

    public void cleanup(List<BusinessTransaction> items) {
    }
}

