/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.communicationdetails;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.events.CommunicationDetails;
import org.hawkular.btm.api.utils.EndpointUtil;
import org.hawkular.btm.processor.communicationdetails.ProducerInfo;
import org.hawkular.btm.processor.communicationdetails.ProducerInfoCache;
import org.hawkular.btm.server.api.task.AbstractProcessor;

public class CommunicationDetailsDeriver
extends AbstractProcessor<BusinessTransaction, CommunicationDetails> {
    protected static final String CLIENT_PREFIX = "[client]";
    private static final Logger log = Logger.getLogger(CommunicationDetailsDeriver.class.getName());
    @Inject
    private ProducerInfoCache producerInfoCache;

    public ProducerInfoCache getProducerInfoCache() {
        return this.producerInfoCache;
    }

    public void setProducerInfoCache(ProducerInfoCache producerInfoCache) {
        this.producerInfoCache = producerInfoCache;
    }

    public void initialise(String tenantId, List<BusinessTransaction> items) {
        for (int i = 0; i < items.size(); ++i) {
            Origin originUri = new Origin();
            BusinessTransaction btxn = items.get(i);
            for (int j = 0; j < btxn.getNodes().size(); ++j) {
                Node node = (Node)btxn.getNodes().get(j);
                this.initialiseNode(tenantId, btxn, originUri, node);
            }
        }
    }

    protected void initialiseNode(String tenantId, BusinessTransaction btxn, Origin origin, Node node) {
        block6: {
            block5: {
                if (node.getClass() != Producer.class) break block5;
                Producer producer = (Producer)node;
                if (origin.getUri() == null) {
                    origin.setUri(CLIENT_PREFIX + producer.getUri());
                }
                long diffns = producer.getBaseTime() - ((Node)btxn.getNodes().get(0)).getBaseTime();
                long diffms = TimeUnit.MILLISECONDS.convert(diffns, TimeUnit.NANOSECONDS);
                long timestamp = btxn.getStartTime() + diffms;
                List cids = producer.getCorrelationIds(CorrelationIdentifier.Scope.Interaction);
                if (cids.isEmpty()) break block6;
                for (int i = 0; i < cids.size(); ++i) {
                    ProducerInfo pi = new ProducerInfo();
                    pi.setSourceUri(origin.getUri());
                    pi.setSourceOperation(origin.getOperation());
                    pi.setTimestamp(timestamp);
                    pi.setDuration(producer.getDuration());
                    pi.setFragmentId(btxn.getId());
                    pi.setHostName(btxn.getHostName());
                    pi.setHostAddress(btxn.getHostAddress());
                    pi.setMultipleConsumers(producer.multipleConsumers());
                    pi.getProperties().putAll(btxn.getProperties());
                    this.producerInfoCache.put(tenantId, ((CorrelationIdentifier)cids.get(i)).getValue(), pi);
                }
                break block6;
            }
            if (node instanceof ContainerNode) {
                if (origin.getUri() == null && node.getClass() == Consumer.class) {
                    origin.setUri(node.getUri());
                    origin.setOperation(node.getOperation());
                }
                for (int j = 0; j < ((ContainerNode)node).getNodes().size(); ++j) {
                    this.initialiseNode(tenantId, btxn, origin, (Node)((ContainerNode)node).getNodes().get(j));
                }
            }
        }
    }

    public boolean isMultiple() {
        return false;
    }

    public CommunicationDetails processSingle(String tenantId, BusinessTransaction item) throws Exception {
        Consumer consumer;
        List cids;
        CommunicationDetails ret = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derive communication details for business transaction fragment: " + item);
        }
        if (item.getNodes().size() == 1 && ((Node)item.getNodes().get(0)).getClass() == Consumer.class && !(cids = (consumer = (Consumer)item.getNodes().get(0)).getCorrelationIds(CorrelationIdentifier.Scope.Interaction)).isEmpty()) {
            String lastId = null;
            for (int i = 0; ret == null && i < cids.size(); ++i) {
                String id = ((CorrelationIdentifier)cids.get(i)).getValue();
                ProducerInfo pi = this.producerInfoCache.get(tenantId, id);
                if (pi != null) {
                    ret = new CommunicationDetails();
                    ret.setId(id);
                    ret.setBusinessTransaction(item.getName());
                    ret.setSource(EndpointUtil.encodeEndpoint((String)pi.getSourceUri(), (String)pi.getSourceOperation()));
                    ret.setTarget(EndpointUtil.encodeEndpoint((String)consumer.getUri(), (String)consumer.getOperation()));
                    long diff = TimeUnit.MILLISECONDS.convert(pi.getDuration() - consumer.getDuration(), TimeUnit.NANOSECONDS);
                    if (diff > 0L) {
                        ret.setLatency(diff / 2L);
                    } else if (diff < 0L && log.isLoggable(Level.FINEST)) {
                        log.finest("WARNING: Negative latency for consumer = " + consumer);
                    }
                    ret.setProducerDuration(pi.getDuration());
                    ret.setConsumerDuration(consumer.getDuration());
                    ret.setMultiConsumer(pi.isMultipleConsumers());
                    ret.setInternal(consumer.getEndpointType() == null);
                    ret.getProperties().putAll(item.getProperties());
                    ret.getProperties().putAll(pi.getProperties());
                    ret.setSourceFragmentId(pi.getFragmentId());
                    ret.setSourceHostName(pi.getHostName());
                    ret.setSourceHostAddress(pi.getHostAddress());
                    ret.setTargetFragmentId(item.getId());
                    ret.setTargetHostName(item.getHostName());
                    ret.setTargetHostAddress(item.getHostAddress());
                    ret.setTargetFragmentDuration(item.calculateDuration());
                    ret.setPrincipal(item.getPrincipal());
                    ret.setTimestamp(pi.getTimestamp());
                    long timestampOffset = item.getStartTime() - pi.getTimestamp() - ret.getLatency();
                    ret.setTimestampOffset(timestampOffset);
                    CommunicationDetailsDeriver.initialiseOutbound(consumer.getNodes(), ((Node)item.getNodes().get(0)).getBaseTime(), ret);
                    continue;
                }
                lastId = id;
            }
            if (ret == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("WARNING: Producer information not available [last id checked = " + lastId + "]");
                }
                throw new RuntimeException("Producer information not available [last id checked = " + lastId + "]");
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derived communication details: " + ret);
        }
        return ret;
    }

    protected static void initialiseOutbound(List<Node> consumerNodes, long baseTime, CommunicationDetails cd) {
        for (int i = 0; i < consumerNodes.size(); ++i) {
            Node n = consumerNodes.get(i);
            if (n.getClass() == Producer.class) {
                CommunicationDetails.Outbound ob = new CommunicationDetails.Outbound();
                for (int j = 0; j < ((Producer)n).getCorrelationIds().size(); ++j) {
                    CorrelationIdentifier ci = (CorrelationIdentifier)((Producer)n).getCorrelationIds().get(j);
                    if (ci.getScope() != CorrelationIdentifier.Scope.Interaction) continue;
                    ob.getIds().add(ci.getValue());
                }
                if (ob.getIds().isEmpty()) continue;
                ob.setMultiConsumer(((Producer)n).multipleConsumers());
                ob.setProducerOffset(TimeUnit.MILLISECONDS.convert(n.getBaseTime() - baseTime, TimeUnit.NANOSECONDS));
                cd.getOutbound().add(ob);
                continue;
            }
            if (!n.containerNode()) continue;
            CommunicationDetailsDeriver.initialiseOutbound(((ContainerNode)n).getNodes(), baseTime, cd);
        }
    }

    public List<CommunicationDetails> processMultiple(String tenantId, BusinessTransaction item) throws Exception {
        return null;
    }

    public void cleanup(String tenantId, List<BusinessTransaction> items) {
    }

    public class Origin {
        private String uri;
        private String operation;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }
    }
}

