/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.config.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.btm.api.model.config.btxn.ConfigMessage;
import org.hawkular.btm.api.services.ConfigurationLoader;
import org.hawkular.btm.api.services.ConfigurationService;

public class ConfigurationServiceRESTClient
implements ConfigurationService {
    private static final Logger log = Logger.getLogger((String)ConfigurationServiceRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTxnSummary>> BTXN_SUMMARY_LIST = new TypeReference<List<BusinessTxnSummary>>(){};
    private static final TypeReference<Map<String, BusinessTxnConfig>> BUSINESS_TXN_MAP = new TypeReference<Map<String, BusinessTxnConfig>>(){};
    private static final TypeReference<List<ConfigMessage>> CONFIG_MESSAGE_LIST = new TypeReference<List<ConfigMessage>>(){};
    private static final String HAWKULAR_PERSONA = "Hawkular-Persona";
    private String username = System.getProperty("hawkular-btm.username");
    private String password = System.getProperty("hawkular-btm.password");
    private String authorization = null;
    private String baseUrl = System.getProperty("hawkular-btm.base-uri");

    public ConfigurationServiceRESTClient() {
        if (this.baseUrl != null && this.baseUrl.length() > 0 && this.baseUrl.charAt(this.baseUrl.length() - 1) != '/') {
            this.baseUrl = this.baseUrl + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public CollectorConfiguration getCollector(String tenantId, String host, String server) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get collector configuration: tenantId=[" + tenantId + "] host=[" + host + "] server=[" + server + "]");
        }
        if (System.getProperty("hawkular-btm.config") != null) {
            return ConfigurationLoader.getConfiguration();
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/collector");
        if (host != null) {
            builder.append("?host=");
            builder.append(host);
        }
        if (server != null) {
            if (host == null) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append("server=");
            builder.append(server);
        }
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                try {
                    return (CollectorConfiguration)mapper.readValue(resp.toString(), CollectorConfiguration.class);
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get collector configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'get' collector configuration request", (Throwable)e);
        }
        return null;
    }

    public List<ConfigMessage> updateBusinessTransaction(String tenantId, String name, BusinessTxnConfig config) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Update busioess transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "] config=[" + config + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/businesstxn/full/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes((Object)config));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Update business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to update business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to update business transaction  [" + name + "] configuration", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<ConfigMessage> validateBusinessTransaction(BusinessTxnConfig config) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Validate busioess transaction configuration: config=[" + config + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/businesstxn/validate");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, null);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes((Object)config));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Validate business transaction configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to validate business transaction configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to validate business transaction configuration", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public BusinessTxnConfig getBusinessTransaction(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/businesstxn/full/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (BusinessTxnConfig)mapper.readValue(resp.toString(), BusinessTxnConfig.class);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction [" + name + "] configuration", (Throwable)e);
        }
        return null;
    }

    public List<BusinessTxnSummary> getBusinessTransactionSummaries(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction summaries: tenantId=[" + tenantId + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/businesstxn/summary");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), BTXN_SUMMARY_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction summaries: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction summaries", (Throwable)e);
        }
        return null;
    }

    public Map<String, BusinessTxnConfig> getBusinessTransactions(String tenantId, long updated) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction configurations: tenantId=[" + tenantId + "] updated=[" + updated + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/businesstxn/full?updated=").append(updated);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (Map)mapper.readValue(resp.toString(), BUSINESS_TXN_MAP);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction configurations", (Throwable)e);
        }
        return null;
    }

    public void removeBusinessTransaction(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Update busioess transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "]]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("config/businesstxn/full/").append(name);
        try {
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            connection.getResponseCode();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Remove business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to remove business transaction  [" + name + "] configuration", (Throwable)e);
        }
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_PERSONA, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    public void clear(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Clear business transaction configurations: tenantId=[" + tenantId + "]");
        }
        try {
            URL url = new URL(this.getBaseUrl() + "config");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Business transaction configs cleared");
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to clear business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'clear' business transaction config request", (Throwable)e);
        }
    }
}

