/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.btm.api.model.trace.BusinessTransactionTrace;
import org.hawkular.btm.api.processors.BusinessTransactionTraceHandler;
import org.hawkular.btm.processor.metrics.BTxnMetric;
import org.hawkular.btm.processor.metrics.MetricsService;
import org.hawkular.btm.processor.metrics.log.MsgLogger;
import org.jboss.logging.Logger;

public class BTxnTraceMetricsDeriver
implements BusinessTransactionTraceHandler {
    private final Logger log = Logger.getLogger(BTxnTraceMetricsDeriver.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    @Inject
    private Instance<MetricsService> injectedMetricsService;
    private MetricsService metricsService;
    private BusinessTransactionTraceHandler retryHandler;

    @PostConstruct
    public void init() {
        if (this.injectedMetricsService.isUnsatisfied()) {
            this.msgLog.warnNoMetricsService();
        } else {
            this.metricsService = (MetricsService)this.injectedMetricsService.get();
        }
    }

    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public BusinessTransactionTraceHandler getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(BusinessTransactionTraceHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    public void handle(String tenantId, List<BusinessTransactionTrace> traces) {
        this.log.tracef("Metrics Deriver called with: %s", traces);
        ArrayList<BusinessTransactionTrace> retry = null;
        HashSet<BTxnMetric> metrics = null;
        for (int i = 0; i < traces.size(); ++i) {
            if (!traces.get(i).isComplete()) continue;
            try {
                List<BTxnMetric> txnMetrics = this.derive(traces.get(i));
                if (txnMetrics == null || txnMetrics.isEmpty()) continue;
                if (metrics == null) {
                    metrics = new HashSet<BTxnMetric>();
                }
                metrics.addAll(txnMetrics);
                continue;
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to process trace", (Throwable)e);
                if (retry == null) {
                    retry = new ArrayList<BusinessTransactionTrace>();
                }
                retry.add(traces.get(i));
            }
        }
        if (retry != null && this.getRetryHandler() != null) {
            this.log.tracef("Retry %d traces", (Object)retry.size());
            this.getRetryHandler().handle(tenantId, (List)retry);
        }
        if (metrics != null && this.getMetricsService() != null) {
            try {
                this.getMetricsService().report(tenantId, metrics);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected List<BTxnMetric> derive(BusinessTransactionTrace trace) {
        return Collections.emptyList();
    }
}

