/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.analytics.ResponseTime;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.server.api.task.Processor;

public class ResponseTimeDeriver
implements Processor<BusinessTransaction, ResponseTime> {
    private static final Logger log = Logger.getLogger(ResponseTimeDeriver.class.getName());

    public boolean isMultiple() {
        return true;
    }

    public ResponseTime processSingle(BusinessTransaction item) throws Exception {
        return null;
    }

    public List<ResponseTime> processMultiple(BusinessTransaction item) throws Exception {
        ArrayList<ResponseTime> ret = new ArrayList<ResponseTime>();
        long baseTime = 0L;
        if (!item.getNodes().isEmpty()) {
            baseTime = ((Node)item.getNodes().get(0)).getBaseTime();
        }
        this.deriveResponseTimes(item, baseTime, item.getNodes(), ret);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ResponseTimeDeriver [" + ret.size() + "] ret=" + ret);
        }
        return ret;
    }

    protected void deriveResponseTimes(BusinessTransaction btxn, long baseTime, List<Node> nodes, List<ResponseTime> rts) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            long diffns = n.getBaseTime() - baseTime;
            long diffms = TimeUnit.MILLISECONDS.convert(diffns, TimeUnit.NANOSECONDS);
            ResponseTime rt = new ResponseTime();
            rt.setId(btxn.getId() + "-" + rts.size());
            rt.setBusinessTransaction(btxn.getName());
            rt.setCorrelationIds(n.getCorrelationIds());
            rt.setDetails(n.getDetails());
            rt.setDuration(n.getDuration());
            if (n.getFault() != null && n.getFault().trim().length() > 0) {
                rt.setFault(n.getFault());
            }
            rt.setProperties(btxn.getProperties());
            rt.setTimestamp(btxn.getStartTime() + diffms);
            rt.setType(n.getType());
            rt.setUri(n.getUri());
            rts.add(rt);
            if (!n.interactionNode()) continue;
            this.deriveResponseTimes(btxn, baseTime, ((InteractionNode)n).getNodes(), rts);
        }
    }
}

