/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.responsetime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.NodeType;
import org.hawkular.btm.api.model.events.NodeDetails;
import org.hawkular.btm.server.api.task.Processor;

public class NodeDetailsDeriver
implements Processor<BusinessTransaction, NodeDetails> {
    private static final Logger log = Logger.getLogger(NodeDetailsDeriver.class.getName());

    public boolean isMultiple() {
        return true;
    }

    public NodeDetails processSingle(BusinessTransaction item) throws Exception {
        return null;
    }

    public List<NodeDetails> processMultiple(BusinessTransaction item) throws Exception {
        ArrayList<NodeDetails> ret = new ArrayList<NodeDetails>();
        long baseTime = 0L;
        if (!item.getNodes().isEmpty()) {
            baseTime = ((Node)item.getNodes().get(0)).getBaseTime();
        }
        this.deriveNodeDetails(item, baseTime, item.getNodes(), ret);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("NodeDetailsDeriver [" + ret.size() + "] ret=" + ret);
        }
        return ret;
    }

    protected void deriveNodeDetails(BusinessTransaction btxn, long baseTime, List<Node> nodes, List<NodeDetails> rts) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            long diffns = n.getBaseTime() - baseTime;
            long diffms = TimeUnit.MILLISECONDS.convert(diffns, TimeUnit.NANOSECONDS);
            NodeDetails nd = new NodeDetails();
            nd.setId(btxn.getId() + "-" + rts.size());
            nd.setBusinessTransaction(btxn.getName());
            nd.setCorrelationIds(n.getCorrelationIds());
            nd.setDetails(n.getDetails());
            nd.setElapsed(n.getDuration());
            long childElapsed = 0L;
            if (n.containerNode()) {
                for (int j = 0; j < ((ContainerNode)n).getNodes().size(); ++j) {
                    childElapsed += ((Node)((ContainerNode)n).getNodes().get(j)).getDuration();
                }
            }
            nd.setActual(n.getDuration() - childElapsed);
            if (n.getType() == NodeType.Component) {
                nd.setComponentType(((Component)n).getComponentType());
                nd.setOperation(((Component)n).getOperation());
            } else {
                nd.setComponentType(n.getType().name());
            }
            if (n.getFault() != null && n.getFault().trim().length() > 0) {
                nd.setFault(n.getFault());
            }
            if (btxn.getHostName() != null && btxn.getHostName().trim().length() > 0) {
                nd.setHostName(btxn.getHostName());
            }
            nd.setProperties(btxn.getProperties());
            nd.setTimestamp(btxn.getStartTime() + diffms);
            nd.setType(n.getType());
            nd.setUri(n.getUri());
            rts.add(nd);
            if (!n.interactionNode()) continue;
            this.deriveNodeDetails(btxn, baseTime, ((InteractionNode)n).getNodes(), rts);
        }
    }
}

