/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;

@MessageDriven(name="BusinessTransactions_Elasticsearch", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="BusinessTransactions")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class BusinessTransactionMDBElasticsearch
implements MessageListener {
    private static final String BUSINESS_TRANSACTION_TYPE = "businesstransaction";
    private static final Logger log = Logger.getLogger(BusinessTransactionMDBElasticsearch.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    private ElasticsearchClient client;

    @PostConstruct
    public void init() {
        this.client = new ElasticsearchClient();
        try {
            this.client.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to initialise Elasticsearch", e);
        }
    }

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Elasticsearch: Business transactions received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            this.client.initTenant(tenantId);
            String data = ((TextMessage)message).getText();
            List btxns = (List)mapper.readValue(data, BUSINESS_TXN_LIST);
            BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
            for (int i = 0; i < btxns.size(); ++i) {
                BusinessTransaction btxn = (BusinessTransaction)btxns.get(i);
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BUSINESS_TRANSACTION_TYPE, btxn.getId()).setSource(mapper.writeValueAsString((Object)btxn)));
            }
            BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
            if (bulkItemResponses.hasFailures()) {
                log.severe("Failed to store business transactions: " + bulkItemResponses.buildFailureMessage());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Failed to store business transactions to elasticsearch: " + bulkItemResponses.buildFailureMessage());
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Success storing business transactions to elasticsearch");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void close() {
        this.client.close();
    }
}

