/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

@Singleton
public class BusinessTransactionServiceElasticsearch
implements BusinessTransactionService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String BUSINESS_TRANSACTION_TYPE = "businesstransaction";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ElasticsearchClient client;
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;

    @PostConstruct
    public void init() {
        this.client = new ElasticsearchClient();
        try {
            this.client.init();
        }
        catch (Exception e) {
            this.msgLog.errorFailedToInitialiseElasticsearchClient(e);
        }
    }

    protected void store(String tenantId, List<BusinessTransaction> btxns) {
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < btxns.size(); ++i) {
            BusinessTransaction btxn = btxns.get(i);
            try {
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BUSINESS_TRANSACTION_TYPE, btxn.getId()).setSource(mapper.writeValueAsString((Object)btxn)));
                continue;
            }
            catch (JsonProcessingException e) {
                this.msgLog.error("Failed to store business transaction", e);
            }
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store business transactions: " + bulkItemResponses.buildFailureMessage());
        }
    }

    public BusinessTransaction get(String tenantId, String id) {
        BusinessTransaction ret = null;
        GetResponse response = (GetResponse)this.client.getElasticsearchClient().prepareGet(this.client.getIndex(tenantId), BUSINESS_TRANSACTION_TYPE, id).setRouting(id).execute().actionGet();
        if (!response.isSourceEmpty()) {
            try {
                ret = (BusinessTransaction)mapper.readValue(response.getSourceAsString(), BusinessTransaction.class);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParseBusinessTransaction(e);
            }
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Get business transaction with id[%s] is: %s", id, ret);
        }
        return ret;
    }

    public List<BusinessTransaction> query(String tenantId, BusinessTransactionCriteria criteria) {
        SearchResponse response;
        ArrayList<BusinessTransaction> ret = new ArrayList<BusinessTransaction>();
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        long startTime = criteria.getStartTime();
        long endTime = criteria.getEndTime();
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == 0L) {
            startTime = endTime - 3600000L;
        }
        BoolQueryBuilder b2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"startTime").from(startTime).to(endTime));
        if (!criteria.getCorrelationIds().isEmpty()) {
            for (CorrelationIdentifier id : criteria.getCorrelationIds()) {
                b2.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)id.getValue()));
            }
        }
        if (!criteria.getProperties().isEmpty()) {
            for (String key : criteria.getProperties().keySet()) {
                b2 = b2.must((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + key), criteria.getProperties().get(key)));
            }
        }
        if ((response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TRANSACTION_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)b2).execute().actionGet()).isTimedOut()) {
            this.msgLog.warnBusinessTransactionQueryTimedOut();
        }
        for (SearchHit searchHitFields : response.getHits()) {
            try {
                ret.add((BusinessTransaction)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTransaction.class));
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParseBusinessTransaction(e);
            }
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Query business transactions with criteria[%s] is: %s", criteria, ret);
        }
        return ret;
    }
}

