/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.hawkular.btm.api.model.analytics.ResponseTime;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;

@MessageDriven(name="ResponseTimes_Elasticsearch", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="ResponseTimes")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class ResponseTimeMDBElasticsearch
implements MessageListener {
    private static final String RESPONSE_TIME_TYPE = "responsetime";
    private static final Logger log = Logger.getLogger(ResponseTimeMDBElasticsearch.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<ResponseTime>> RESPONSE_TIME_LIST = new TypeReference<List<ResponseTime>>(){};
    private ElasticsearchClient client;

    @PostConstruct
    public void init() {
        this.client = new ElasticsearchClient();
        try {
            this.client.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to initialise Elasticsearch", e);
        }
    }

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Elasticsearch: Repsonse time received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            this.client.initTenant(tenantId);
            String data = ((TextMessage)message).getText();
            List rts = (List)mapper.readValue(data, RESPONSE_TIME_LIST);
            BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
            for (int i = 0; i < rts.size(); ++i) {
                ResponseTime rt = (ResponseTime)rts.get(i);
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), RESPONSE_TIME_TYPE, rt.getId()).setSource(mapper.writeValueAsString((Object)rt)));
            }
            BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
            if (bulkItemResponses.hasFailures()) {
                log.severe("Failed to store response times: " + bulkItemResponses.buildFailureMessage());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Failed to store response times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Success storing response times to elasticsearch");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void close() {
        this.client.close();
    }
}

