/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.services.BaseCriteria;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.CompletionTimeCriteria;

public class ElasticsearchUtil {
    public static BoolQueryBuilder buildQuery(BaseCriteria criteria, String timeProperty, String businessTxnProperty) {
        BoolQueryBuilder query = ElasticsearchUtil.buildBaseQuery(criteria, timeProperty, businessTxnProperty);
        if (criteria instanceof BusinessTransactionCriteria) {
            if (!((BusinessTransactionCriteria)criteria).getCorrelationIds().isEmpty()) {
                for (CorrelationIdentifier id : ((BusinessTransactionCriteria)criteria).getCorrelationIds()) {
                    query.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)id.getValue()));
                }
            }
        } else if (criteria instanceof CompletionTimeCriteria) {
            if (!((CompletionTimeCriteria)criteria).getFaults().isEmpty()) {
                for (CompletionTimeCriteria.FaultCriteria fc : ((CompletionTimeCriteria)criteria).getFaults()) {
                    if (fc.isExcluded()) {
                        query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"fault", (Object)fc.getValue()));
                        continue;
                    }
                    query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"fault", (Object)fc.getValue()));
                }
            }
            if (((CompletionTimeCriteria)criteria).getLowerBound() > 0L || ((CompletionTimeCriteria)criteria).getUpperBound() > 0L) {
                RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"duration");
                if (((CompletionTimeCriteria)criteria).getLowerBound() > 0L) {
                    rangeQuery.gte(((CompletionTimeCriteria)criteria).getLowerBound());
                }
                if (((CompletionTimeCriteria)criteria).getUpperBound() > 0L) {
                    rangeQuery.lte(((CompletionTimeCriteria)criteria).getUpperBound());
                }
                query = query.must((QueryBuilder)rangeQuery);
            }
        }
        return query;
    }

    private static BoolQueryBuilder buildBaseQuery(BaseCriteria criteria, String timeProperty, String businessTxnProperty) {
        long startTime = criteria.getStartTime();
        long endTime = criteria.getEndTime();
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        } else if (endTime < 0L) {
            endTime = System.currentTimeMillis() - endTime;
        }
        if (startTime == 0L) {
            startTime = endTime - 3600000L;
        } else if (startTime < 0L) {
            startTime = endTime + startTime;
        }
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)timeProperty).from(startTime).to(endTime));
        if (criteria.getBusinessTransaction() != null && criteria.getBusinessTransaction().trim().length() > 0) {
            query = query.must((QueryBuilder)QueryBuilders.termQuery((String)businessTxnProperty, (String)criteria.getBusinessTransaction()));
        }
        if (!criteria.getProperties().isEmpty()) {
            for (BaseCriteria.PropertyCriteria pc : criteria.getProperties()) {
                if (pc.isExcluded()) {
                    query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + pc.getName()), (Object)pc.getValue()));
                    continue;
                }
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + pc.getName()), (Object)pc.getValue()));
            }
        }
        if (criteria.getHostName() != null && criteria.getHostName().trim().length() > 0) {
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"hostName", (Object)criteria.getHostName()));
        }
        return query;
    }

    public static FilterBuilder buildFilter(BusinessTransactionCriteria criteria) {
        if (criteria.getBusinessTransaction() != null && criteria.getBusinessTransaction().trim().length() == 0) {
            return FilterBuilders.missingFilter((String)"name");
        }
        return null;
    }
}

