/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public final class ElasticsearchEmbeddedNode {
    private static final Logger log = Logger.getLogger(ElasticsearchEmbeddedNode.class.getName());
    private Client client;
    private Node node;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNode() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(TransportClient.class.getClassLoader());
            Properties properties = new Properties();
            try {
                InputStream stream = this.getClass().getResourceAsStream("/hawkular-btm-elasticsearch.properties");
                properties.load(stream);
                stream.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load elasticsearch properties", e);
            }
            this.node = NodeBuilder.nodeBuilder().settings((Settings.Builder)ImmutableSettings.settingsBuilder().put(properties)).node();
            this.node.start();
            this.client = this.node.client();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Initialized Elasticsearch node=" + this.node + " client=" + this.client);
        }
    }

    public void close() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Close Elasticsearch node=" + this.node + " client=" + this.client);
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.node != null) {
            this.node.stop();
            this.node = null;
        }
    }

    public synchronized Client getClient() {
        if (this.client == null) {
            this.initNode();
        }
        return this.client;
    }
}

