/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.missing.MissingBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.avg.AvgBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.metrics.stats.StatsBuilder;
import org.hawkular.btm.api.model.analytics.Cardinality;
import org.hawkular.btm.api.model.analytics.CommunicationSummaryStatistics;
import org.hawkular.btm.api.model.analytics.CompletionTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.btm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.events.CommunicationDetails;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.model.events.NodeDetails;
import org.hawkular.btm.api.services.AbstractAnalyticsService;
import org.hawkular.btm.api.services.Criteria;
import org.hawkular.btm.server.elasticsearch.BusinessTransactionServiceElasticsearch;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

public class AnalyticsServiceElasticsearch
extends AbstractAnalyticsService {
    private static final Logger log = Logger.getLogger(AnalyticsServiceElasticsearch.class.getName());
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String COMMUNICATION_DETAILS_TYPE = "communicationdetails";
    private static final String NODE_DETAILS_TYPE = "nodedetails";
    private static final String BTXN_COMPLETION_TIME_TYPE = "btxncompletiontime";
    private static final String FRAGMENT_COMPLETION_TIME_TYPE = "fragmentcompletiontime";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private ElasticsearchClient client;

    public ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    public void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    protected List<BusinessTransaction> getFragments(String tenantId, Criteria criteria) {
        return BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
    }

    public long getCompletionCount(String tenantId, Criteria criteria) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        try {
            RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
            this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
            BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
            SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BTXN_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.isTimedOut()) {
                this.msgLog.warnQueryTimedOut();
                return 0L;
            }
            return response.getHits().getTotalHits();
        }
        catch (IndexMissingException t) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("No index found, so unable to get completion count", new Object[0]);
            }
            return 0L;
        }
    }

    public long getCompletionFaultCount(String tenantId, Criteria criteria) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        try {
            RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
            this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
            BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
            ExistsFilterBuilder filter = FilterBuilders.existsFilter((String)"fault");
            SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BTXN_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query).setPostFilter((FilterBuilder)filter);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.isTimedOut()) {
                this.msgLog.warnQueryTimedOut();
                return 0L;
            }
            return response.getHits().getTotalHits();
        }
        catch (IndexMissingException t) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("No index found, so unable to get completion faultcount", new Object[0]);
            }
            return 0L;
        }
    }

    public Percentiles getCompletionPercentiles(String tenantId, Criteria criteria) {
        Percentiles percentiles;
        block5: {
            if (criteria.getBusinessTransaction() == null) {
                throw new IllegalArgumentException("Business transaction name not specified");
            }
            String index = this.client.getIndex(tenantId);
            percentiles = new Percentiles();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                PercentilesBuilder percentileAgg = (PercentilesBuilder)AggregationBuilders.percentiles((String)"percentiles").field("duration");
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BTXN_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)percentileAgg).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles agg = (org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles)response.getAggregations().get("percentiles");
                for (Percentile entry : agg) {
                    percentiles.addPercentile((int)entry.getPercent(), (long)entry.getValue());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block5;
                this.msgLog.tracef("No index found, so unable to get completion percentiles", new Object[0]);
            }
        }
        return percentiles;
    }

    public List<CompletionTimeseriesStatistics> getCompletionTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        ArrayList<CompletionTimeseriesStatistics> stats;
        block5: {
            if (criteria.getBusinessTransaction() == null) {
                throw new IllegalArgumentException("Business transaction name not specified");
            }
            String index = this.client.getIndex(tenantId);
            stats = new ArrayList<CompletionTimeseriesStatistics>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                StatsBuilder statsBuilder = (StatsBuilder)AggregationBuilders.stats((String)"stats").field("duration");
                MissingBuilder faultCountBuilder = AggregationBuilders.missing((String)"faults").field("fault");
                DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)statsBuilder)).subAggregation((AbstractAggregationBuilder)faultCountBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BTXN_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)histogramBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
                for (DateHistogram.Bucket bucket : histogram.getBuckets()) {
                    Stats stat = (Stats)bucket.getAggregations().get("stats");
                    Missing missing = (Missing)bucket.getAggregations().get("faults");
                    CompletionTimeseriesStatistics s = new CompletionTimeseriesStatistics();
                    s.setTimestamp(bucket.getKeyAsDate().getMillis());
                    s.setAverage((long)stat.getAvg());
                    s.setMin((long)stat.getMin());
                    s.setMax((long)stat.getMax());
                    s.setCount(stat.getCount());
                    s.setFaultCount(stat.getCount() - missing.getDocCount());
                    stats.add(s);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block5;
                this.msgLog.tracef("No index found, so unable to get completion timeseries stats", new Object[0]);
            }
        }
        return stats;
    }

    public List<Cardinality> getCompletionFaultDetails(String tenantId, Criteria criteria) {
        ArrayList<Cardinality> ret;
        block5: {
            if (criteria.getBusinessTransaction() == null) {
                throw new IllegalArgumentException("Business transaction name not specified");
            }
            String index = this.client.getIndex(tenantId);
            ret = new ArrayList<Cardinality>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("fault")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BTXN_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)cardinalityBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms terms = (Terms)response.getAggregations().get("cardinality");
                for (Terms.Bucket bucket : terms.getBuckets()) {
                    Cardinality card = new Cardinality();
                    card.setValue(bucket.getKey());
                    card.setCount(bucket.getDocCount());
                    ret.add(card);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block5;
                this.msgLog.tracef("No index found, so unable to get completion fault details", new Object[0]);
            }
        }
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return (int)(arg1.getCount() - arg0.getCount());
            }
        });
        return ret;
    }

    public List<Cardinality> getCompletionPropertyDetails(String tenantId, Criteria criteria, String property) {
        ArrayList<Cardinality> ret;
        block5: {
            if (criteria.getBusinessTransaction() == null) {
                throw new IllegalArgumentException("Business transaction name not specified");
            }
            String index = this.client.getIndex(tenantId);
            ret = new ArrayList<Cardinality>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("properties." + property)).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BTXN_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)cardinalityBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms terms = (Terms)response.getAggregations().get("cardinality");
                for (Terms.Bucket bucket : terms.getBuckets()) {
                    Cardinality card = new Cardinality();
                    card.setValue(bucket.getKey());
                    card.setCount(bucket.getDocCount());
                    ret.add(card);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block5;
                this.msgLog.tracef("No index found, so unable to get completion property details", new Object[0]);
            }
        }
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return arg0.getValue().compareTo(arg1.getValue());
            }
        });
        return ret;
    }

    public int getAlertCount(String tenantId, String name) {
        return 0;
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        int numOfNodes;
        long queryTime;
        ArrayList<NodeTimeseriesStatistics> stats;
        block7: {
            String index = this.client.getIndex(tenantId);
            stats = new ArrayList<NodeTimeseriesStatistics>();
            queryTime = 0L;
            numOfNodes = 0;
            if (log.isLoggable(Level.FINEST)) {
                queryTime = System.currentTimeMillis();
            }
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                AvgBuilder avgBuilder = (AvgBuilder)AggregationBuilders.avg((String)"avg").field("actual");
                TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)avgBuilder);
                DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)componentsBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{NODE_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)histogramBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
                for (DateHistogram.Bucket bucket : histogram.getBuckets()) {
                    Terms term = (Terms)bucket.getAggregations().get("components");
                    NodeTimeseriesStatistics s = new NodeTimeseriesStatistics();
                    s.setTimestamp(bucket.getKeyAsDate().getMillis());
                    for (Terms.Bucket termBucket : term.getBuckets()) {
                        Avg avg = (Avg)termBucket.getAggregations().get("avg");
                        s.getComponentTypes().put(termBucket.getKey(), new NodeTimeseriesStatistics.NodeComponentTypeStatistics((long)avg.getValue(), termBucket.getDocCount()));
                    }
                    stats.add(s);
                    numOfNodes = (int)((long)numOfNodes + bucket.getDocCount());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block7;
                this.msgLog.tracef("No index found, so unable to get node timeseries stats", new Object[0]);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms and " + "number of nodes processed = " + numOfNodes);
        }
        return stats;
    }

    public Collection<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, Criteria criteria) {
        ArrayList<NodeSummaryStatistics> stats;
        block16: {
            String index = this.client.getIndex(tenantId);
            stats = new ArrayList<NodeSummaryStatistics>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                AvgBuilder actualBuilder = (AvgBuilder)AggregationBuilders.avg((String)"actual").field("actual");
                AvgBuilder elapsedBuilder = (AvgBuilder)AggregationBuilders.avg((String)"elapsed").field("elapsed");
                TermsBuilder operationsBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"operations").field("operation")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
                MissingBuilder missingOperationBuilder = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingOperation").field("operation").subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
                TermsBuilder urisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)operationsBuilder)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder);
                TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)urisBuilder);
                TermsBuilder interactionUrisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
                MissingBuilder missingComponentsBuilder = (MissingBuilder)AggregationBuilders.missing((String)"missingcomponent").field("componentType").subAggregation((AbstractAggregationBuilder)interactionUrisBuilder);
                TermsBuilder nodesBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"types").field("type")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)componentsBuilder)).subAggregation((AbstractAggregationBuilder)missingComponentsBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{NODE_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)nodesBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms types = (Terms)response.getAggregations().get("types");
                for (Terms.Bucket typeBucket : types.getBuckets()) {
                    Terms components = (Terms)typeBucket.getAggregations().get("components");
                    for (Terms.Bucket componentBucket : components.getBuckets()) {
                        Terms uris = (Terms)componentBucket.getAggregations().get("uris");
                        for (Terms.Bucket uriBucket : uris.getBuckets()) {
                            Terms operations = (Terms)uriBucket.getAggregations().get("operations");
                            for (Terms.Bucket operationBucket : operations.getBuckets()) {
                                Avg actual = (Avg)operationBucket.getAggregations().get("actual");
                                Avg elapsed = (Avg)operationBucket.getAggregations().get("elapsed");
                                NodeSummaryStatistics stat = new NodeSummaryStatistics();
                                if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
                                    stat.setComponentType("consumer");
                                } else if (typeBucket.getKey().equalsIgnoreCase("producer")) {
                                    stat.setComponentType("producer");
                                } else {
                                    stat.setComponentType(componentBucket.getKey());
                                }
                                stat.setUri(uriBucket.getKey());
                                stat.setOperation(operationBucket.getKey());
                                stat.setActual((long)actual.getValue());
                                stat.setElapsed((long)elapsed.getValue());
                                stat.setCount(operationBucket.getDocCount());
                                stats.add(stat);
                            }
                            Missing missingOp = (Missing)uriBucket.getAggregations().get("missingOperation");
                            Avg actual = (Avg)missingOp.getAggregations().get("actual");
                            Avg elapsed = (Avg)missingOp.getAggregations().get("elapsed");
                            if (actual.getValueAsString().equals("NaN")) continue;
                            NodeSummaryStatistics stat = new NodeSummaryStatistics();
                            if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
                                stat.setComponentType("consumer");
                            } else if (typeBucket.getKey().equalsIgnoreCase("producer")) {
                                stat.setComponentType("producer");
                            } else {
                                stat.setComponentType(componentBucket.getKey());
                            }
                            stat.setUri(uriBucket.getKey());
                            stat.setActual((long)actual.getValue());
                            stat.setElapsed((long)elapsed.getValue());
                            stat.setCount(missingOp.getDocCount());
                            stats.add(stat);
                        }
                    }
                    Missing missingComponents = (Missing)typeBucket.getAggregations().get("missingcomponent");
                    Terms uris = (Terms)missingComponents.getAggregations().get("uris");
                    for (Terms.Bucket uriBucket : uris.getBuckets()) {
                        Avg actual = (Avg)uriBucket.getAggregations().get("actual");
                        Avg elapsed = (Avg)uriBucket.getAggregations().get("elapsed");
                        NodeSummaryStatistics stat = new NodeSummaryStatistics();
                        stat.setComponentType(typeBucket.getKey());
                        stat.setUri(uriBucket.getKey());
                        stat.setActual((long)actual.getValue());
                        stat.setElapsed((long)elapsed.getValue());
                        stat.setCount(uriBucket.getDocCount());
                        stats.add(stat);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block16;
                this.msgLog.tracef("No index found, so unable to get node summary stats", new Object[0]);
            }
        }
        return stats;
    }

    public Collection<CommunicationSummaryStatistics> getCommunicationSummaryStatistics(String tenantId, Criteria criteria) {
        HashMap<String, CommunicationSummaryStatistics> stats;
        block8: {
            String index = this.client.getIndex(tenantId);
            stats = new HashMap<String, CommunicationSummaryStatistics>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                StatsBuilder latencyBuilder = (StatsBuilder)AggregationBuilders.stats((String)"latency").field("latency");
                TermsBuilder urisBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)latencyBuilder);
                TermsBuilder originsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"origins").field("originUri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)urisBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMMUNICATION_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)originsBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms origins = (Terms)response.getAggregations().get("origins");
                for (Terms.Bucket originBucket : origins.getBuckets()) {
                    Terms uris = (Terms)originBucket.getAggregations().get("uris");
                    CommunicationSummaryStatistics css = new CommunicationSummaryStatistics();
                    css.setUri(originBucket.getKey());
                    css.setCount(originBucket.getDocCount());
                    stats.put(css.getUri(), css);
                    for (Terms.Bucket uriBucket : uris.getBuckets()) {
                        Stats latency = (Stats)uriBucket.getAggregations().get("latency");
                        CommunicationSummaryStatistics.ConnectionStatistics con = new CommunicationSummaryStatistics.ConnectionStatistics();
                        con.setMinimumLatency((long)latency.getMin());
                        con.setAverageLatency((long)latency.getAvg());
                        con.setMaximumLatency((long)latency.getMax());
                        con.setCount(uriBucket.getDocCount());
                        css.getOutbound().put(uriBucket.getKey(), con);
                    }
                }
                StatsBuilder durationBuilder = (StatsBuilder)AggregationBuilders.stats((String)"duration").field("duration");
                TermsBuilder completionsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"completions").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)durationBuilder);
                SearchRequestBuilder request2 = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{FRAGMENT_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)completionsBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response2 = (SearchResponse)request2.execute().actionGet();
                if (response2.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms completions = (Terms)response2.getAggregations().get("completions");
                for (Terms.Bucket completionBucket : completions.getBuckets()) {
                    Stats duration = (Stats)completionBucket.getAggregations().get("duration");
                    String uri = completionBucket.getKey();
                    CommunicationSummaryStatistics css = (CommunicationSummaryStatistics)stats.get(uri);
                    if (css == null) {
                        css = new CommunicationSummaryStatistics();
                        css.setUri(uri);
                        stats.put(uri, css);
                    }
                    css.setMinimumDuration((long)duration.getMin());
                    css.setAverageDuration((long)duration.getAvg());
                    css.setMaximumDuration((long)duration.getMax());
                    css.setCount(completionBucket.getDocCount());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block8;
                this.msgLog.tracef("No index found, so unable to get communication summary stats", new Object[0]);
            }
        }
        return stats.values();
    }

    public void storeCommunicationDetails(String tenantId, List<CommunicationDetails> communicationDetails) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < communicationDetails.size(); ++i) {
            CommunicationDetails cd = communicationDetails.get(i);
            String json = mapper.writeValueAsString((Object)cd);
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Storing communication details: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), COMMUNICATION_DETAILS_TYPE, cd.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store communication details: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store communication details to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing communication details to elasticsearch");
        }
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < nodeDetails.size(); ++i) {
            NodeDetails rt = nodeDetails.get(i);
            String json = mapper.writeValueAsString((Object)rt);
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Storing node details: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), NODE_DETAILS_TYPE, rt.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store node details: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store node details to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing node details to elasticsearch");
        }
    }

    public void storeBTxnCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < completionTimes.size(); ++i) {
            CompletionTime ct = completionTimes.get(i);
            String json = mapper.writeValueAsString((Object)ct);
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Storing btxn completion time: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BTXN_COMPLETION_TIME_TYPE, ct.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store btxn completion times: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store btxn completion times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing btxn completion times to elasticsearch");
        }
    }

    public void storeFragmentCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < completionTimes.size(); ++i) {
            CompletionTime ct = completionTimes.get(i);
            String json = mapper.writeValueAsString((Object)ct);
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Storing fragment completion time: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), FRAGMENT_COMPLETION_TIME_TYPE, ct.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store fragment completion times: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store fragment completion times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing fragment completion times to elasticsearch");
        }
    }

    public List<String> getHostNames(String tenantId, Criteria criteria) {
        ArrayList<String> ret;
        block7: {
            ret = new ArrayList<String>();
            String index = this.client.getIndex(tenantId);
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "startTime", "name");
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{"businesstransaction"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                ArrayList<Object> btxns = new ArrayList<Object>();
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        btxns.add(mapper.readValue(searchHitFields.getSourceAsString(), BusinessTransaction.class));
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
                for (int i = 0; i < btxns.size(); ++i) {
                    BusinessTransaction btxn = (BusinessTransaction)btxns.get(i);
                    if (btxn.getHostName() == null || btxn.getHostName().trim().length() == 0 || ret.contains(btxn.getHostName())) continue;
                    ret.add(btxn.getHostName());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block7;
                this.msgLog.tracef("No index found, so unable to get host names", new Object[0]);
            }
        }
        Collections.sort(ret);
        return ret;
    }

    public void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        try {
            this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
            this.client.clear(tenantId);
        }
        catch (IndexMissingException indexMissingException) {
            // empty catch block
        }
    }
}

