/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.btm.api.model.config.btxn.ConfigMessage;
import org.hawkular.btm.api.services.AbstractConfigurationService;
import org.hawkular.btm.api.services.ConfigurationLoader;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

public class ConfigurationServiceElasticsearch
extends AbstractConfigurationService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String BUSINESS_TXN_CONFIG_TYPE = "businesstxnconfig";
    private static final String BUSINESS_TXN_CONFIG_INVALID_TYPE = "businesstxnconfiginvalid";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private ElasticsearchClient client;
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;

    public ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    public void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public CollectorConfiguration getCollector(String tenantId, String host, String server) {
        CollectorConfiguration config;
        block6: {
            config = ConfigurationLoader.getConfiguration();
            try {
                String index = this.client.getIndex(tenantId);
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        BusinessTxnConfig btc = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if (btc.isDeleted()) continue;
                        config.getBusinessTransactions().put(searchHitFields.getId(), btc);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction configs", new Object[0]);
            }
        }
        return config;
    }

    public List<ConfigMessage> setBusinessTransaction(String tenantId, String name, BusinessTxnConfig config) throws Exception {
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Update business transaction config with name[%s] config=%s", name, config);
        }
        List messages = this.validateBusinessTransaction(config);
        config.setLastUpdated(System.currentTimeMillis());
        String index = messages.isEmpty() ? BUSINESS_TXN_CONFIG_TYPE : BUSINESS_TXN_CONFIG_INVALID_TYPE;
        IndexRequestBuilder builder = this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), index, name).setRouting(name).setSource(mapper.writeValueAsString((Object)config));
        builder.execute().actionGet();
        if (messages.isEmpty()) {
            ConfigMessage cm = new ConfigMessage();
            cm.setSeverity(Severity.Info);
            cm.setMessage("Configuration successfully published");
            messages.add(cm);
            DeleteRequestBuilder deletion = this.client.getElasticsearchClient().prepareDelete(this.client.getIndex(tenantId), BUSINESS_TXN_CONFIG_INVALID_TYPE, name);
            deletion.execute().actionGet();
        } else {
            ConfigMessage cm = new ConfigMessage();
            cm.setSeverity(Severity.Warning);
            cm.setMessage("Configuration has not been published due to previous errors and/or warnings");
            messages.add(cm);
        }
        return messages;
    }

    public BusinessTxnConfig getBusinessTransaction(String tenantId, String name) {
        BusinessTxnConfig ret;
        block8: {
            ret = null;
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Get business transaction config with name[%s]", name);
            }
            try {
                String index = this.client.getIndex(tenantId);
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                GetResponse response = (GetResponse)this.client.getElasticsearchClient().prepareGet(index, BUSINESS_TXN_CONFIG_INVALID_TYPE, name).setRouting(name).execute().actionGet();
                if (response.isSourceEmpty()) {
                    response = (GetResponse)this.client.getElasticsearchClient().prepareGet(index, BUSINESS_TXN_CONFIG_TYPE, name).setRouting(name).execute().actionGet();
                }
                if (response.isSourceEmpty()) break block8;
                try {
                    ret = (BusinessTxnConfig)mapper.readValue(response.getSourceAsString(), BusinessTxnConfig.class);
                    if (ret.isDeleted()) {
                        ret = null;
                    }
                }
                catch (Exception e) {
                    this.msgLog.errorFailedToParse(e);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block8;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction config [%s]", name);
            }
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Get business transaction config with name[%s] is: %s", name, ret);
        }
        return ret;
    }

    public List<BusinessTxnSummary> getBusinessTransactionSummaries(String tenantId) {
        ArrayList<BusinessTxnSummary> ret;
        block10: {
            ret = new ArrayList<BusinessTxnSummary>();
            String index = this.client.getIndex(tenantId);
            try {
                BusinessTxnSummary summary;
                BusinessTxnConfig config;
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                ArrayList<String> names = new ArrayList<String>();
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        config = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if (config.isDeleted()) continue;
                        summary = new BusinessTxnSummary();
                        summary.setName(searchHitFields.getId());
                        summary.setDescription(config.getDescription());
                        summary.setLevel(config.getLevel());
                        ret.add(summary);
                        names.add(summary.getName());
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
                response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_INVALID_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        config = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if (names.contains(searchHitFields.getId())) continue;
                        summary = new BusinessTxnSummary();
                        summary.setName(searchHitFields.getId());
                        summary.setDescription(config.getDescription());
                        summary.setLevel(config.getLevel());
                        ret.add(summary);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block10;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction summaries", new Object[0]);
            }
        }
        return ret;
    }

    public Map<String, BusinessTxnConfig> getBusinessTransactions(String tenantId, long updated) {
        HashMap<String, BusinessTxnConfig> ret;
        block6: {
            ret = new HashMap<String, BusinessTxnConfig>();
            String index = this.client.getIndex(tenantId);
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        BusinessTxnConfig btxn = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if ((updated != 0L || btxn.isDeleted()) && (updated <= 0L || btxn.getLastUpdated() <= updated)) continue;
                        ret.put(searchHitFields.getId(), btxn);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction names", new Object[0]);
            }
        }
        return ret;
    }

    public void removeBusinessTransaction(String tenantId, String name) throws Exception {
        BusinessTxnConfig config = new BusinessTxnConfig();
        config.setDeleted(true);
        config.setLastUpdated(System.currentTimeMillis());
        IndexRequestBuilder builder = this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BUSINESS_TXN_CONFIG_TYPE, name).setRouting(name).setSource(mapper.writeValueAsString((Object)config));
        builder.execute().actionGet();
        DeleteRequestBuilder deletion = this.client.getElasticsearchClient().prepareDelete(this.client.getIndex(tenantId), BUSINESS_TXN_CONFIG_INVALID_TYPE, name);
        deletion.execute().actionGet();
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Remove business transaction config with name[%s]", name);
        }
    }

    public void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        try {
            this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
            this.client.clear(tenantId);
        }
        catch (IndexMissingException indexMissingException) {
            // empty catch block
        }
    }
}

