/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.tests.client.jav;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.tests.client.jav.TopLevelService;

public class ClientJavaMain {
    private static final int SHUTDOWN_TIMER = 30000;
    private static final Logger log = Logger.getLogger(ClientJavaMain.class.getName());
    private Undertow server = null;
    private String host = System.getProperty("hawkular-btm.testapp.host");
    private int port = Integer.parseInt(System.getProperty("hawkular-btm.testapp.port"));

    public static void main(String[] args) {
        ClientJavaMain main = new ClientJavaMain();
        try {
            main.run();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Failed to run client java main", t);
        }
    }

    public void run() {
        log.info("************ TEST CLIENT JAVA APP STARTED: host=" + this.host + " port=" + this.port);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                log.severe("************** ABORTING TEST CLIENT JAVA APP");
                System.exit(1);
            }
        });
        t.setDaemon(true);
        t.start();
        final TopLevelService main = new TopLevelService();
        this.server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)Handlers.path().addPrefixPath("testOp", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String mesg = (String)((Deque)exchange.getQueryParameters().get("mesg")).getFirst();
                String num = (String)((Deque)exchange.getQueryParameters().get("num")).getFirst();
                log.info("Test op called with mesg=" + mesg + " and num=" + num);
                String resp = main.testOp(mesg, Integer.parseInt(num));
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                exchange.getResponseSender().send(resp);
            }
        }).addPrefixPath("shutdown", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                log.info("Shutdown called");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                exchange.getResponseSender().send("ok");
                ClientJavaMain.this.shutdown();
            }
        })).build();
        this.server.start();
    }

    public void shutdown() {
        log.info("************ TEST CLIENT JAVA APP EXITING");
        this.server.stop();
        System.exit(0);
    }
}

