/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.sample.client;

import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.SimpleBasicMessage;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.producer.ProducerConnectionContext;

public class Main {
    private static final String BROKER_URL = "vm://mybroker?broker.persistent=false";
    private static final Endpoint ENDPOINT = new Endpoint(Endpoint.Type.QUEUE, "myqueue");

    public static void main(String[] args) throws Exception {
        Consumer consumer = new Consumer();
        Producer producer = new Producer();
        consumer.consume();
        producer.produce();
        Thread.sleep(1000L);
        consumer.cleanUp();
        producer.cleanUp();
    }

    private static class Producer {
        ConnectionContextFactory cachedFactory;

        private Producer() {
        }

        public void produce() throws Exception {
            ConnectionContextFactory factory = new ConnectionContextFactory(Main.BROKER_URL);
            ProducerConnectionContext pc = factory.createProducerConnectionContext(ENDPOINT);
            SimpleBasicMessage msg = new SimpleBasicMessage("hello from " + Main.class);
            MessageProcessor processor = new MessageProcessor();
            processor.send(pc, (BasicMessage)msg);
            this.cachedFactory = factory;
        }

        public void cleanUp() throws Exception {
            this.cachedFactory.close();
        }
    }

    private static class Consumer {
        ConnectionContextFactory cachedFactory;

        private Consumer() {
        }

        public void consume() throws Exception {
            ConnectionContextFactory factory = new ConnectionContextFactory(Main.BROKER_URL);
            ConsumerConnectionContext context = factory.createConsumerConnectionContext(ENDPOINT);
            BasicMessageListener<SimpleBasicMessage> listener = new BasicMessageListener<SimpleBasicMessage>(){

                protected void onBasicMessage(SimpleBasicMessage msg) {
                    System.out.println("Consumed message===>" + msg.getMessage());
                }
            };
            MessageProcessor processor = new MessageProcessor();
            processor.listen(context, (AbstractBasicMessageListener)listener);
            this.cachedFactory = factory;
        }

        public void cleanUp() throws Exception {
            this.cachedFactory.close();
        }
    }
}

