/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.sample.msg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.bus.common.AbstractMessage;
import org.hawkular.bus.sample.msg.Address;
import org.hawkular.bus.sample.msg.PhoneNumber;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"firstName", "lastName", "title", "age", "favoriteColors", "books", "hobbies", "address", "phoneNumbers"})
public class Person
extends AbstractMessage {
    @JsonProperty(value="firstName")
    private String firstName;
    @JsonProperty(value="lastName")
    private String lastName;
    @JsonProperty(value="title")
    private Title title;
    @JsonProperty(value="age")
    private Integer age;
    @JsonProperty(value="favoriteColors")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> favoriteColors = new LinkedHashSet<String>();
    @JsonProperty(value="books")
    private List<String> books = new ArrayList<String>();
    @JsonProperty(value="hobbies")
    private Map<String, Number> hobbies;
    @JsonProperty(value="address")
    private Address address;
    @JsonProperty(value="phoneNumbers")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<PhoneNumber> phoneNumbers = new LinkedHashSet<PhoneNumber>();

    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="title")
    public Title getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(Title title) {
        this.title = title;
    }

    @JsonProperty(value="age")
    public Integer getAge() {
        return this.age;
    }

    @JsonProperty(value="age")
    public void setAge(Integer age) {
        this.age = age;
    }

    @JsonProperty(value="favoriteColors")
    public Set<String> getFavoriteColors() {
        return this.favoriteColors;
    }

    @JsonProperty(value="favoriteColors")
    public void setFavoriteColors(Set<String> favoriteColors) {
        this.favoriteColors = favoriteColors;
    }

    @JsonProperty(value="books")
    public List<String> getBooks() {
        return this.books;
    }

    @JsonProperty(value="books")
    public void setBooks(List<String> books) {
        this.books = books;
    }

    @JsonProperty(value="hobbies")
    public Map<String, Number> getHobbies() {
        return this.hobbies;
    }

    @JsonProperty(value="hobbies")
    public void setHobbies(Map<String, Number> hobbies) {
        this.hobbies = hobbies;
    }

    @JsonProperty(value="address")
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="phoneNumbers")
    public Set<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="phoneNumbers")
    public void setPhoneNumbers(Set<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public static enum Title {
        MR("Mr."),
        MRS("Mrs."),
        MISS("Miss"),
        DR("Dr.");

        private final String value;
        private static Map<String, Title> constants;

        private Title(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Title fromValue(String value) {
            Title constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Title>();
            for (Title c : Title.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

