
package org.hawkular.cmdgw.api;

import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Adds a Datasource or a XA Datasource to a resource.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "resourcePath",
    "xaDatasource",
    "datasourceName",
    "jndiName",
    "driverName",
    "driverClass",
    "connectionUrl",
    "xaDataSourceClass",
    "datasourceProperties",
    "userName",
    "password",
    "securityDomain"
})
public class AddDatasourceRequest
    extends AuthMessage
{

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     */
    @JsonProperty("resourcePath")
    private java.lang.String resourcePath;
    /**
     * true if an XA datasource should be added, false otherwise
     * 
     */
    @JsonProperty("xaDatasource")
    private boolean xaDatasource;
    /**
     * The name for this datasource.
     * (Required)
     * 
     */
    @JsonProperty("datasourceName")
    private java.lang.String datasourceName;
    /**
     * the JNDI name for the datasource
     * (Required)
     * 
     */
    @JsonProperty("jndiName")
    private java.lang.String jndiName;
    /**
     * Name of the JDBC driver as available under /subsystem=datasources/jdbc-driver=* in WildFly configuration.
     * (Required)
     * 
     */
    @JsonProperty("driverName")
    private java.lang.String driverName;
    /**
     * The fully qualified name of the JDBC driver class. For non-XA Datasources either needs to be explicitly set here or in the JDBC driver referenced in driverName.
     * 
     */
    @JsonProperty("driverClass")
    private java.lang.String driverClass;
    /**
     * The JDBC driver connection URL. Required for non-XA datasources.
     * 
     */
    @JsonProperty("connectionUrl")
    private java.lang.String connectionUrl;
    /**
     * The fully qualified name of the javax.sql.XADataSource implementation. For XA Datasources either needs to be explicitly set here or in the JDBC driver referenced in driverName.
     * 
     */
    @JsonProperty("xaDataSourceClass")
    private java.lang.String xaDataSourceClass;
    /**
     * Either a list of xa-datasource-properties in case this is a XA datasource or otherwise a list of connection-properties for a non-XA datasource.
     * 
     */
    @JsonProperty("datasourceProperties")
    private Map<String, String> datasourceProperties;
    /**
     * The user name used when creating a new connection.
     * 
     */
    @JsonProperty("userName")
    private java.lang.String userName;
    /**
     * The password used when creating a new connection.
     * 
     */
    @JsonProperty("password")
    private java.lang.String password;
    /**
     * The security domain which defines the javax.security.auth.Subject that are used to distinguish connections in the pool.
     * 
     */
    @JsonProperty("securityDomain")
    private java.lang.String securityDomain;

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     * @return
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public java.lang.String getResourcePath() {
        return resourcePath;
    }

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     * @param resourcePath
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public void setResourcePath(java.lang.String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * true if an XA datasource should be added, false otherwise
     * 
     * @return
     *     The xaDatasource
     */
    @JsonProperty("xaDatasource")
    public boolean isXaDatasource() {
        return xaDatasource;
    }

    /**
     * true if an XA datasource should be added, false otherwise
     * 
     * @param xaDatasource
     *     The xaDatasource
     */
    @JsonProperty("xaDatasource")
    public void setXaDatasource(boolean xaDatasource) {
        this.xaDatasource = xaDatasource;
    }

    /**
     * The name for this datasource.
     * (Required)
     * 
     * @return
     *     The datasourceName
     */
    @JsonProperty("datasourceName")
    public java.lang.String getDatasourceName() {
        return datasourceName;
    }

    /**
     * The name for this datasource.
     * (Required)
     * 
     * @param datasourceName
     *     The datasourceName
     */
    @JsonProperty("datasourceName")
    public void setDatasourceName(java.lang.String datasourceName) {
        this.datasourceName = datasourceName;
    }

    /**
     * the JNDI name for the datasource
     * (Required)
     * 
     * @return
     *     The jndiName
     */
    @JsonProperty("jndiName")
    public java.lang.String getJndiName() {
        return jndiName;
    }

    /**
     * the JNDI name for the datasource
     * (Required)
     * 
     * @param jndiName
     *     The jndiName
     */
    @JsonProperty("jndiName")
    public void setJndiName(java.lang.String jndiName) {
        this.jndiName = jndiName;
    }

    /**
     * Name of the JDBC driver as available under /subsystem=datasources/jdbc-driver=* in WildFly configuration.
     * (Required)
     * 
     * @return
     *     The driverName
     */
    @JsonProperty("driverName")
    public java.lang.String getDriverName() {
        return driverName;
    }

    /**
     * Name of the JDBC driver as available under /subsystem=datasources/jdbc-driver=* in WildFly configuration.
     * (Required)
     * 
     * @param driverName
     *     The driverName
     */
    @JsonProperty("driverName")
    public void setDriverName(java.lang.String driverName) {
        this.driverName = driverName;
    }

    /**
     * The fully qualified name of the JDBC driver class. For non-XA Datasources either needs to be explicitly set here or in the JDBC driver referenced in driverName.
     * 
     * @return
     *     The driverClass
     */
    @JsonProperty("driverClass")
    public java.lang.String getDriverClass() {
        return driverClass;
    }

    /**
     * The fully qualified name of the JDBC driver class. For non-XA Datasources either needs to be explicitly set here or in the JDBC driver referenced in driverName.
     * 
     * @param driverClass
     *     The driverClass
     */
    @JsonProperty("driverClass")
    public void setDriverClass(java.lang.String driverClass) {
        this.driverClass = driverClass;
    }

    /**
     * The JDBC driver connection URL. Required for non-XA datasources.
     * 
     * @return
     *     The connectionUrl
     */
    @JsonProperty("connectionUrl")
    public java.lang.String getConnectionUrl() {
        return connectionUrl;
    }

    /**
     * The JDBC driver connection URL. Required for non-XA datasources.
     * 
     * @param connectionUrl
     *     The connectionUrl
     */
    @JsonProperty("connectionUrl")
    public void setConnectionUrl(java.lang.String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    /**
     * The fully qualified name of the javax.sql.XADataSource implementation. For XA Datasources either needs to be explicitly set here or in the JDBC driver referenced in driverName.
     * 
     * @return
     *     The xaDataSourceClass
     */
    @JsonProperty("xaDataSourceClass")
    public java.lang.String getXaDataSourceClass() {
        return xaDataSourceClass;
    }

    /**
     * The fully qualified name of the javax.sql.XADataSource implementation. For XA Datasources either needs to be explicitly set here or in the JDBC driver referenced in driverName.
     * 
     * @param xaDataSourceClass
     *     The xaDataSourceClass
     */
    @JsonProperty("xaDataSourceClass")
    public void setXaDataSourceClass(java.lang.String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    /**
     * Either a list of xa-datasource-properties in case this is a XA datasource or otherwise a list of connection-properties for a non-XA datasource.
     * 
     * @return
     *     The datasourceProperties
     */
    @JsonProperty("datasourceProperties")
    public Map<String, String> getDatasourceProperties() {
        return datasourceProperties;
    }

    /**
     * Either a list of xa-datasource-properties in case this is a XA datasource or otherwise a list of connection-properties for a non-XA datasource.
     * 
     * @param datasourceProperties
     *     The datasourceProperties
     */
    @JsonProperty("datasourceProperties")
    public void setDatasourceProperties(Map<String, String> datasourceProperties) {
        this.datasourceProperties = datasourceProperties;
    }

    /**
     * The user name used when creating a new connection.
     * 
     * @return
     *     The userName
     */
    @JsonProperty("userName")
    public java.lang.String getUserName() {
        return userName;
    }

    /**
     * The user name used when creating a new connection.
     * 
     * @param userName
     *     The userName
     */
    @JsonProperty("userName")
    public void setUserName(java.lang.String userName) {
        this.userName = userName;
    }

    /**
     * The password used when creating a new connection.
     * 
     * @return
     *     The password
     */
    @JsonProperty("password")
    public java.lang.String getPassword() {
        return password;
    }

    /**
     * The password used when creating a new connection.
     * 
     * @param password
     *     The password
     */
    @JsonProperty("password")
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * The security domain which defines the javax.security.auth.Subject that are used to distinguish connections in the pool.
     * 
     * @return
     *     The securityDomain
     */
    @JsonProperty("securityDomain")
    public java.lang.String getSecurityDomain() {
        return securityDomain;
    }

    /**
     * The security domain which defines the javax.security.auth.Subject that are used to distinguish connections in the pool.
     * 
     * @param securityDomain
     *     The securityDomain
     */
    @JsonProperty("securityDomain")
    public void setSecurityDomain(java.lang.String securityDomain) {
        this.securityDomain = securityDomain;
    }

}
