
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Adds a Datasource or a XA Datasource to a resource. The awkward name of the schema file A1ResourcePathRequest.schema.json is there so that this schema file precedes all other schema files alphabetically. This is required by jsonschema2pojo-maven-plugin that is not resolving the inter-schema dependencies, it just takes files in alphabetical order.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "resourcePath",
    "senderRequestId",
    "senderSessionId"
})
public class ResourcePathRequest
    extends AuthMessage
    implements ResourcePathDestination, UiSessionOrigin
{

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     */
    @JsonProperty("resourcePath")
    private String resourcePath;
    /**
     * An ID chosen by the sending UI client that should make it possible to associate future responses with this request. This ID is supposed to be unique just within the current WebSocket session.
     * 
     */
    @JsonProperty("senderRequestId")
    private String senderRequestId;
    /**
     * UI clients do not need to set this, the server will overwrite this field based on the ID of the present WebSocket session ID.
     * 
     */
    @JsonProperty("senderSessionId")
    private String senderSessionId;

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     * @return
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public String getResourcePath() {
        return resourcePath;
    }

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     * @param resourcePath
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * An ID chosen by the sending UI client that should make it possible to associate future responses with this request. This ID is supposed to be unique just within the current WebSocket session.
     * 
     * @return
     *     The senderRequestId
     */
    @JsonProperty("senderRequestId")
    public String getSenderRequestId() {
        return senderRequestId;
    }

    /**
     * An ID chosen by the sending UI client that should make it possible to associate future responses with this request. This ID is supposed to be unique just within the current WebSocket session.
     * 
     * @param senderRequestId
     *     The senderRequestId
     */
    @JsonProperty("senderRequestId")
    public void setSenderRequestId(String senderRequestId) {
        this.senderRequestId = senderRequestId;
    }

    /**
     * UI clients do not need to set this, the server will overwrite this field based on the ID of the present WebSocket session ID.
     * 
     * @return
     *     The senderSessionId
     */
    @JsonProperty("senderSessionId")
    public String getSenderSessionId() {
        return senderSessionId;
    }

    /**
     * UI clients do not need to set this, the server will overwrite this field based on the ID of the present WebSocket session ID.
     * 
     * @param senderSessionId
     *     The senderSessionId
     */
    @JsonProperty("senderSessionId")
    public void setSenderSessionId(String senderSessionId) {
        this.senderSessionId = senderSessionId;
    }

}
