/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ApiDeserializer;
import org.hawkular.cmdgw.command.ws.server.WebSocketHelper;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public class WebSocketHelper {
    private static final MsgLogger log = GatewayLoggers.getLogger(WebSocketHelper.class);
    private Long asyncTimeout;

    public WebSocketHelper() {
        this.asyncTimeout = null;
    }

    public WebSocketHelper(Long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    public void sendTextSync(Session session, String text) throws IOException {
        RemoteEndpoint.Basic basicRemote = session.getBasicRemote();
        basicRemote.sendText(text);
    }

    public void sendBasicMessageSync(Session session, BasicMessage msg) throws IOException {
        this.sendTextSync(session, ApiDeserializer.toHawkularFormat((BasicMessage)msg));
    }

    public void sendTextAsync(Session session, String text) {
        RemoteEndpoint.Async asyncRemote = session.getAsyncRemote();
        if (this.asyncTimeout != null) {
            asyncRemote.setSendTimeout(this.asyncTimeout.longValue());
        }
        asyncRemote.sendText(text);
    }

    public void sendBasicMessageAsync(Session session, BasicMessage msg) {
        String text = ApiDeserializer.toHawkularFormat((BasicMessage)msg);
        this.sendTextAsync(session, text);
    }

    public void sendSync(Session session, BasicMessageWithExtraData<? extends BasicMessage> message) throws IOException {
        BinaryData binary = message.getBinaryData();
        if (binary == null) {
            this.sendBasicMessageSync(session, message.getBasicMessage());
        } else {
            BinaryData serialized = ApiDeserializer.toHawkularFormat((BasicMessage)message.getBasicMessage(), (InputStream)message.getBinaryData());
            this.sendBinarySync(session, (InputStream)serialized);
        }
    }

    public void sendBinaryAsync(Session session, InputStream inputStream, ExecutorService threadPool) {
        if (session == null) {
            return;
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        log.debugf("Attempting to send async binary data to client [%s]", (Object)session.getId());
        if (session.isOpen()) {
            if (this.asyncTimeout != null) {
                // empty if block
            }
            CopyStreamRunnable runnable = new CopyStreamRunnable(this, session, inputStream);
            threadPool.execute((Runnable)runnable);
        }
    }

    public void sendBinarySync(Session session, InputStream inputStream) throws IOException {
        if (session == null) {
            return;
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        log.debugf("Attempting to send binary data to client [%s]", (Object)session.getId());
        if (session.isOpen()) {
            long size = new CopyStreamRunnable(this, session, inputStream).copyInputToOutput();
            log.debugf("Finished sending binary data to client [%s]: size=[%s]", (Object)session.getId(), (Object)size);
        }
    }

    static /* synthetic */ MsgLogger access$000() {
        return log;
    }
}

