/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.bus;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

@ApplicationScoped
@Default
public class BusConnectionFactoryProvider {
    private static final MsgLogger log = GatewayLoggers.getLogger(BusConnectionFactoryProvider.class);
    private volatile ConnectionFactory connectionFactory;
    private final Object connectionFactoryLock = new Object();
    private final int connectionFactoryLookupTimeoutMs = Integer.parseInt(System.getProperty("hawkular.cmdgw.connectionFactoryLookupTimeoutMs", String.valueOf(30000)));
    private final int connectionFactoryRetryAfterMs = Integer.parseInt(System.getProperty("hawkular.cmdgw.connectionFactoryLookupRetryAfterMs", String.valueOf(250)));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            Object object = this.connectionFactoryLock;
            synchronized (object) {
                int attemptCount;
                block10: {
                    long start = System.currentTimeMillis();
                    attemptCount = 0;
                    while (true) {
                        try {
                            ++attemptCount;
                            this.connectionFactory = (ConnectionFactory)new InitialContext().lookup("java:/HawkularBusConnectionFactory");
                        }
                        catch (NameNotFoundException e) {
                            log.debugf((Throwable)e, "Attempt no. [%d] to lookup [%s] was not successful. Trying again in [%d] ms.", (Object)attemptCount, (Object)"java:/HawkularBusConnectionFactory", (Object)this.connectionFactoryRetryAfterMs);
                        }
                        catch (NamingException e) {
                            throw new RuntimeException(log.errFailedToLookupConnectionFactory(ConnectionFactory.class.getName(), "java:/HawkularBusConnectionFactory"), e);
                        }
                        if (this.connectionFactory != null) break block10;
                        if (start + (long)this.connectionFactoryLookupTimeoutMs >= System.currentTimeMillis()) break;
                        log.debugf("Attempt no. [%d] to lookup [%s] was not successful. Trying again in [%d] ms.", (Object)attemptCount, (Object)"java:/HawkularBusConnectionFactory", (Object)this.connectionFactoryRetryAfterMs);
                        try {
                            Thread.sleep(this.connectionFactoryRetryAfterMs);
                        }
                        catch (InterruptedException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                    throw new RuntimeException(log.errFailedToLookupConnectionFactory(ConnectionFactory.class.getName(), "java:/HawkularBusConnectionFactory", (long)this.connectionFactoryLookupTimeoutMs));
                }
                log.debugf("Attempt no. [%d] to lookup [%s] succeeded.", (Object)attemptCount, (Object)"java:/HawkularBusConnectionFactory");
            }
        }
        return this.connectionFactory;
    }
}

