/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws;

import java.util.Collections;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.cmdgw.Constants;
import org.hawkular.cmdgw.api.UiSessionDestination;
import org.hawkular.cmdgw.command.ws.WsCommand;
import org.hawkular.cmdgw.command.ws.WsCommandContext;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public class UiSessionDestinationWsCommand
implements WsCommand<UiSessionDestination> {
    private static final MsgLogger log = GatewayLoggers.getLogger(UiSessionDestinationWsCommand.class);

    public void execute(BasicMessageWithExtraData<UiSessionDestination> message, WsCommandContext context) throws Exception {
        UiSessionDestination request = (UiSessionDestination)message.getBasicMessage();
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(Constants.UI_COMMAND_QUEUE);
            MessageId mid = new MessageProcessor().send(pcc, message, Collections.singletonMap("uiClientId", request.getDestinationSessionId()));
            log.debugf("Request forwarded to WebSocket. mid=[%s], request=[%s]", (Object)mid, (Object)request);
        }
    }
}

