/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws.server;

import java.io.InputStream;
import java.util.Collection;
import javax.inject.Inject;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.cmdgw.NoCommandForMessageException;
import org.hawkular.cmdgw.api.ApiDeserializer;
import org.hawkular.cmdgw.api.AuthMessage;
import org.hawkular.cmdgw.api.GenericErrorResponse;
import org.hawkular.cmdgw.api.GenericErrorResponseBuilder;
import org.hawkular.cmdgw.api.UiSessionOrigin;
import org.hawkular.cmdgw.command.bus.BusEndpointProcessors;
import org.hawkular.cmdgw.command.ws.WsCommand;
import org.hawkular.cmdgw.command.ws.WsCommandContext;
import org.hawkular.cmdgw.command.ws.WsCommandContextFactory;
import org.hawkular.cmdgw.command.ws.WsCommands;
import org.hawkular.cmdgw.command.ws.WsEndpoints;
import org.hawkular.cmdgw.command.ws.server.WebSocketHelper;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public abstract class AbstractGatewayWebSocket {
    private static final MsgLogger log = GatewayLoggers.getLogger(AbstractGatewayWebSocket.class);
    @Inject
    protected WsCommandContextFactory commandContextFactory;
    protected final String endpoint;
    @Inject
    protected WsCommands wsCommands;
    @Inject
    protected WsEndpoints wsEndpoints;
    @Inject
    protected BusEndpointProcessors busEndpointProcessors;

    public AbstractGatewayWebSocket(String endpoint) {
        this.endpoint = endpoint;
    }

    protected void handleRequest(Session session, BasicMessageWithExtraData<BasicMessage> requestWithBinary) throws NoCommandForMessageException, Exception {
        BasicMessage request = requestWithBinary.getBasicMessage();
        if (request instanceof UiSessionOrigin) {
            log.tracef("[%s] is an instance of [%s]", (Object)request.getClass().getName(), (Object)UiSessionOrigin.class.getName());
            ((UiSessionOrigin)request).setSenderSessionId(session.getId());
        }
        if (request instanceof AuthMessage) {
            ((AuthMessage)request).setAuthentication(null);
        }
        Class<?> requestClass = request.getClass();
        Collection commands = this.wsCommands.getCommands(requestClass);
        for (WsCommand command : commands) {
            log.debugf("About to execute command [%s] on message [%s] in session [%s] of [%s]", new Object[]{command.getClass(), requestClass.getName(), session.getId(), this.endpoint});
            WsCommandContext context = this.commandContextFactory.newCommandContext(session);
            command.execute(requestWithBinary, context);
        }
    }

    @OnMessage
    public void onBinaryMessage(InputStream binaryDataStream, Session session) {
        String requestClassName = "?";
        try {
            BasicMessageWithExtraData reqWithData = new ApiDeserializer().deserialize(binaryDataStream);
            BasicMessage request = reqWithData.getBasicMessage();
            requestClassName = request.getClass().getName();
            log.infoReceivedBinaryData(requestClassName, session.getId(), this.endpoint);
            this.handleRequest(session, reqWithData);
        }
        catch (Throwable t) {
            log.errorWsCommandExecutionFailure(requestClassName, session.getId(), this.endpoint, t);
            String errorMessage = "BusCommand failed [" + requestClassName + "]";
            this.sendErrorResponse(session, errorMessage, t);
        }
    }

    @OnMessage
    public void onMessage(String nameAndJsonStr, Session session) {
        String requestClassName = "?";
        try {
            BasicMessageWithExtraData request = new ApiDeserializer().deserialize(nameAndJsonStr);
            requestClassName = request.getBasicMessage().getClass().getName();
            log.infoReceivedWsMessage(requestClassName, session.getId(), this.endpoint);
            this.handleRequest(session, request);
        }
        catch (Throwable t) {
            log.errorWsCommandExecutionFailure(requestClassName, session.getId(), this.endpoint, t);
            String errorMessage = "Failed to process message [" + requestClassName + "]";
            this.sendErrorResponse(session, errorMessage, t);
        }
    }

    protected void sendErrorResponse(Session session, String errorMessage, Throwable t) {
        BasicMessageWithExtraData response = new BasicMessageWithExtraData((BasicMessage)new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build(), null);
        try {
            new WebSocketHelper().sendSync(session, response);
        }
        catch (Throwable t2) {
            log.errorFailedToSendErrorResponse(t2, ((GenericErrorResponse)response.getBasicMessage()).getClass().getName(), session.getId(), this.endpoint);
        }
    }
}

