/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws;

import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.cmdgw.Constants;
import org.hawkular.cmdgw.api.EventDestination;
import org.hawkular.cmdgw.command.ws.WsCommand;
import org.hawkular.cmdgw.command.ws.WsCommandContext;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public class EventDestinationWsCommand
implements WsCommand<EventDestination> {
    private static final MsgLogger log = GatewayLoggers.getLogger(EventDestinationWsCommand.class);

    public void execute(BasicMessageWithExtraData<EventDestination> message, WsCommandContext context) throws Exception {
        EventDestination request = (EventDestination)message.getBasicMessage();
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(Constants.EVENTS_COMMAND_QUEUE);
            MessageId mid = new MessageProcessor().send(pcc, (BasicMessage)request);
            log.debugf("Event forwarded to bus: mid=[%s], request=[%s]", (Object)mid, (Object)request);
        }
    }
}

