/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.commons.cassandra;

import java.io.File;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import org.apache.cassandra.service.CassandraDaemon;
import org.hawkular.commons.cassandra.CassandraYaml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EmbeddedCassandraService {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedCassandraService.class);
    private CassandraDaemon cassandraDaemon;
    private final Object lock = new Object();

    public EmbeddedCassandraService() {
        logger.info("======== Hawkular - Embedded Cassandra ========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Observes @Initialized(value=ApplicationScoped.class) Object ignore) {
        Object object = this.lock;
        synchronized (object) {
            String backend = System.getProperty("hawkular.backend");
            String tmp = System.getenv("HAWKULAR_BACKEND");
            if (tmp != null) {
                backend = tmp;
                logger.debug("== Using backend setting from environment: " + tmp);
            }
            if (this.cassandraDaemon == null && "embedded_cassandra".equals(backend)) {
                try {
                    File baseDir = new File(System.getProperty("jboss.server.data.dir", "./"), "hawkular-data");
                    File confDir = new File(baseDir, "conf");
                    File yamlFile = new File(confDir, "cassandra.yaml");
                    if (yamlFile.exists()) {
                        System.setProperty("cassandra.config", yamlFile.toURI().toURL().toString());
                    } else {
                        URL defaultCassandraYamlUrl = this.getClass().getResource("/cassandra.yaml");
                        CassandraYaml.builder().load(defaultCassandraYamlUrl).baseDir(baseDir).clusterName("hawkular-data").store(yamlFile).mkdirs().setCassandraConfigProp().setTriggersDirProp();
                    }
                    this.cassandraDaemon = new CassandraDaemon(true);
                    this.cassandraDaemon.activate();
                }
                catch (Exception e) {
                    logger.error("Error initializing embedded Cassandra server", (Throwable)e);
                }
            } else {
                logger.info("== Embedded Cassandra not started as selected backend was " + backend + " ==");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Observes @Destroyed(value=ApplicationScoped.class) Object ignore) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cassandraDaemon != null) {
                this.cassandraDaemon.deactivate();
            }
        }
    }
}

