/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.api.base;

import java.util.List;
import org.hawkular.datamining.api.PredictionListener;
import org.hawkular.datamining.api.model.Metric;
import org.hawkular.datamining.forecast.AutomaticForecaster;
import org.hawkular.datamining.forecast.DataPoint;
import org.hawkular.datamining.forecast.MetricContext;

public class DataMiningForecaster
extends AutomaticForecaster {
    private PredictionListener predictionListener;

    public DataMiningForecaster(Metric context) {
        super((MetricContext)context);
    }

    public void learn(DataPoint dataPoint) {
        super.learn(dataPoint);
        this.automaticPrediction();
    }

    public void learn(List<DataPoint> data) {
        super.learn(data);
        this.automaticPrediction();
    }

    public Metric context() {
        return (Metric)super.context();
    }

    public void setPredictionListener(PredictionListener predictionListener) {
        this.predictionListener = predictionListener;
    }

    private void automaticPrediction() {
        if (this.initialized()) {
            Long forecastingHorizon = this.context().getForecastingHorizon();
            if (this.predictionListener != null && forecastingHorizon != null) {
                int nAhead = (int)(forecastingHorizon / this.context().getCollectionInterval()) + 1;
                List prediction = this.forecast(nAhead);
                this.predictionListener.send(prediction, this.context().getTenant(), this.context().getMetricId());
            }
        }
    }
}

