/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.api.model;

import org.hawkular.datamining.api.model.MetricType;
import org.hawkular.datamining.forecast.MetricContext;

public class Metric
implements MetricContext {
    private final String id;
    private final String feed;
    private final String tenant;
    private Long collectionInterval;
    private Long forecastingHorizon;
    private MetricType metricType;

    public Metric(String tenant, String feed, String id, Long collectionInterval, Long forecastingHorizon, MetricType metricType) {
        this.tenant = tenant;
        this.feed = feed;
        this.id = id;
        this.collectionInterval = collectionInterval;
        this.forecastingHorizon = forecastingHorizon;
        this.metricType = metricType;
    }

    public Metric(Metric that) {
        this.tenant = that.getTenant();
        this.feed = that.getFeed();
        this.id = that.getMetricId();
        this.collectionInterval = that.getCollectionInterval();
        this.forecastingHorizon = that.forecastingHorizon;
        this.metricType = that.metricType;
    }

    public Metric(RestBlueprint restBlueprint, String tenant, String feed) {
        this.collectionInterval = restBlueprint.getCollectionInterval();
        this.id = restBlueprint.getMetricId();
        this.tenant = tenant;
        this.feed = feed;
    }

    public void setCollectionInterval(Long collectionInterval) {
        this.collectionInterval = collectionInterval;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getMetricId() {
        return this.id;
    }

    public Long getCollectionInterval() {
        if (this.collectionInterval != null) {
            return this.collectionInterval;
        }
        if (this.metricType != null && this.metricType.getCollectionInterval() != null) {
            return this.metricType.getCollectionInterval();
        }
        return null;
    }

    public String getFeed() {
        return this.feed;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public Long getForecastingHorizon() {
        return this.forecastingHorizon;
    }

    public void setForecastingHorizon(Long forecastingHorizon) {
        this.forecastingHorizon = forecastingHorizon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)o;
        if (!this.tenant.equals(metric.tenant)) {
            return false;
        }
        return this.id.equals(metric.id);
    }

    public int hashCode() {
        int result = this.tenant.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public static class Update {
        private Long collectionInterval;
        private Long forecastingHorizon;

        private Update() {
        }

        public Update(Long collectionInterval, Long forecastingHorizon) {
            this.collectionInterval = collectionInterval;
            this.forecastingHorizon = forecastingHorizon;
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }

        public Long getForecastingHorizon() {
            return this.forecastingHorizon;
        }
    }

    public static class RestBlueprint {
        private String metricId;
        private Long collectionInterval;

        public RestBlueprint() {
        }

        public RestBlueprint(String metricId, Long collectionInterval) {
            this.metricId = metricId;
            this.collectionInterval = collectionInterval;
        }

        public String getMetricId() {
            return this.metricId;
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }
    }
}

