/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.api.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hawkular.datamining.api.Logger;
import org.hawkular.datamining.api.PredictionListener;
import org.hawkular.datamining.api.Subscription;
import org.hawkular.datamining.api.SubscriptionManager;
import org.hawkular.datamining.api.exception.SubscriptionAlreadyExistsException;
import org.hawkular.datamining.api.exception.SubscriptionNotFoundException;
import org.hawkular.datamining.api.model.Metric;
import org.hawkular.datamining.api.storage.MetricsClient;
import org.hawkular.datamining.forecast.DataPoint;
import org.hawkular.datamining.forecast.Forecaster;

public class InMemorySubscriptionManager
implements SubscriptionManager {
    private final Map<String, TenantsSubscriptionsHolder> subscriptions = new ConcurrentHashMap<String, TenantsSubscriptionsHolder>();
    private final MetricsClient restMetricsClient;
    private PredictionListener predictionListener;

    public InMemorySubscriptionManager(MetricsClient metricsClient) {
        this.restMetricsClient = metricsClient;
    }

    @Override
    public Set<Subscription> subscriptionsOfTenant(String tenant) {
        TenantsSubscriptionsHolder tenantsSubscriptionsHolder = this.subscriptions.get(tenant);
        if (tenantsSubscriptionsHolder == null) {
            return Collections.emptySet();
        }
        return new HashSet<Subscription>(tenantsSubscriptionsHolder.getSubscriptions().values());
    }

    @Override
    public void setPredictionListener(PredictionListener predictionListener) {
        this.predictionListener = predictionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Subscription subscription) {
        TenantsSubscriptionsHolder tenantSubscriptions;
        Map<String, TenantsSubscriptionsHolder> map = this.subscriptions;
        synchronized (map) {
            tenantSubscriptions = this.subscriptions.get(subscription.getMetric().getTenant());
            if (tenantSubscriptions == null) {
                tenantSubscriptions = new TenantsSubscriptionsHolder();
                this.subscriptions.put(subscription.getMetric().getTenant(), tenantSubscriptions);
            }
            if (tenantSubscriptions.getSubscriptions().get(subscription.getMetric().getMetricId()) != null) {
                throw new SubscriptionAlreadyExistsException();
            }
        }
        subscription.forecaster().setPredictionListener(this.predictionListener);
        long startTime = System.currentTimeMillis() - subscription.getMetric().getCollectionInterval() * 100L * 1000L;
        List<DataPoint> points = this.restMetricsClient.loadPoints((Metric)subscription.getMetric(), startTime, System.currentTimeMillis());
        subscription.forecaster().learn(points);
        tenantSubscriptions.getSubscriptions().put(subscription.getMetric().getMetricId(), subscription);
        Logger.LOGGER.subscribe(subscription.getMetric().getMetricId(), subscription.getMetric().getTenant());
    }

    @Override
    public void updateMetric(String tenant, String metricId, Metric.Update update) {
        Subscription subscription = this.subscription(tenant, metricId);
        InMemorySubscriptionManager.updateMetric(update, (Metric)subscription.getMetric());
    }

    @Override
    public void updateForecaster(String tenant, String metricId, Forecaster.Update update) {
        Subscription subscription = this.subscription(tenant, metricId);
        subscription.forecaster().update(update);
    }

    @Override
    public void unsubscribeAll(String tenant, String metricId) {
        this.unsubscribe(tenant, metricId, Subscription.SubscriptionOwner.getAllDefined());
    }

    @Override
    public void unsubscribe(String tenant, String metricId, Subscription.SubscriptionOwner subscriptionOwner) {
        this.unsubscribe(tenant, metricId, Collections.singleton(subscriptionOwner));
    }

    @Override
    public void unsubscribe(String tenant, String metricId, Set<Subscription.SubscriptionOwner> subscriptionOwners) {
        TenantsSubscriptionsHolder tenantSubscriptions = this.subscriptions.get(tenant);
        if (tenantSubscriptions == null) {
            throw new SubscriptionNotFoundException(tenant, metricId);
        }
        Subscription subscription = tenantSubscriptions.getSubscriptions().get(metricId);
        if (subscription == null) {
            throw new SubscriptionNotFoundException(tenant, metricId);
        }
        subscriptionOwners.forEach(subscription::removeSubscriptionOwner);
        if (subscription.getSubscriptionOwners().isEmpty()) {
            tenantSubscriptions.getSubscriptions().remove(metricId);
            Logger.LOGGER.debugf("Unsubscribed tenant: %s, metric: %s", tenant, metricId);
        }
    }

    @Override
    public boolean isSubscribed(String tenant, String metricId) {
        TenantsSubscriptionsHolder tenantsModels = this.subscriptions.get(tenant);
        if (tenantsModels == null) {
            return false;
        }
        return tenantsModels.getSubscriptions().containsKey(metricId);
    }

    @Override
    public Subscription subscription(String tenant, String metricId) {
        TenantsSubscriptionsHolder tenantsModels = this.subscriptions.get(tenant);
        if (tenantsModels == null) {
            throw new SubscriptionNotFoundException(tenant, metricId);
        }
        Subscription subscription = tenantsModels.getSubscriptions().get(metricId);
        if (subscription == null) {
            throw new SubscriptionNotFoundException(tenant, metricId);
        }
        return subscription;
    }

    private static Metric updateMetric(Metric.Update update, Metric metric) {
        if (update.getCollectionInterval() != null) {
            metric.setCollectionInterval(update.getCollectionInterval());
        }
        if (update.getForecastingHorizon() != null) {
            metric.setForecastingHorizon(update.getForecastingHorizon());
        }
        return metric;
    }

    private static class TenantsSubscriptionsHolder {
        private Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();

        private TenantsSubscriptionsHolder() {
        }

        public Map<String, Subscription> getSubscriptions() {
            return this.subscriptions;
        }
    }
}

