/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.api.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import org.hawkular.datamining.forecast.AutomaticForecaster;

public class ConceptDriftTypeResolver
implements TypeIdResolver {
    private static final String PACKAGE_FOR_INNER_CLASS = AutomaticForecaster.ConceptDriftStrategy.class.getName().substring(0, AutomaticForecaster.ConceptDriftStrategy.class.getName().indexOf("$"));
    private JavaType mBaseType;

    public void init(JavaType baseType) {
        this.mBaseType = baseType;
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        String simpleName = suggestedType.getSimpleName();
        return simpleName;
    }

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.mBaseType.getRawClass());
    }

    public JavaType typeFromId(String id) {
        Class clazz;
        String clazzName = PACKAGE_FOR_INNER_CLASS + "$" + id;
        try {
            clazz = ClassUtil.findClass((String)clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("cannot find class '" + clazzName + "'");
        }
        return TypeFactory.defaultInstance().constructSpecializedType(this.mBaseType, clazz);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        return this.typeFromId(id);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

