/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.dist.integration.inventory;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.datamining.api.Subscription;
import org.hawkular.datamining.api.SubscriptionManager;
import org.hawkular.datamining.api.base.DataMiningForecaster;
import org.hawkular.datamining.api.base.DataMiningSubscription;
import org.hawkular.datamining.cdi.qualifiers.Eager;
import org.hawkular.datamining.dist.Logger;
import org.hawkular.datamining.dist.integration.inventory.InventoryCDIStorage;
import org.hawkular.datamining.dist.integration.inventory.InventoryStorage;
import org.hawkular.datamining.dist.integration.inventory.InventoryUtil;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;

@Eager
@ApplicationScoped
public class InventoryCDIStorage
implements InventoryStorage {
    @Resource(lookup="java:global/Hawkular/Inventory")
    private Inventory inventory;
    @Inject
    private SubscriptionManager subscriptionManager;
    private PredictionRelationships predictionRelationships;

    @PostConstruct
    public void init() {
        this.predictionRelationships = new PredictionRelationships(null);
        Set predictedMetrics = this.getAllPredictedMetrics();
        predictedMetrics.forEach(metric -> {
            CanonicalPath tenantCp = metric.getPath().getRoot();
            CanonicalPath metricTypeCp = metric.getType().getPath();
            CanonicalPath metricCp = metric.getPath();
            HashSet<Subscription.SubscriptionOwner> subscriptionOwners = new HashSet<Subscription.SubscriptionOwner>();
            CanonicalPath forecastingHorizonCp = null;
            if (this.predictionRelationships.relationships().get(tenantCp) != null) {
                subscriptionOwners.add(Subscription.SubscriptionOwner.Tenant);
                forecastingHorizonCp = tenantCp;
            }
            if (this.predictionRelationships.relationships().get(metricTypeCp) != null) {
                subscriptionOwners.add(Subscription.SubscriptionOwner.MetricType);
                forecastingHorizonCp = metricTypeCp;
            }
            if (this.predictionRelationships.relationships().get(metricCp) != null) {
                subscriptionOwners.add(Subscription.SubscriptionOwner.Metric);
                forecastingHorizonCp = metricCp;
            }
            Long forecastingHorizon = InventoryUtil.parseForecastingHorizon((Relationship)((Relationship)this.predictionRelationships.relationships().get(forecastingHorizonCp)));
            org.hawkular.datamining.api.model.Metric dataMMetric = InventoryUtil.convertMetric((Metric)metric, (Long)forecastingHorizon);
            DataMiningSubscription subscription = new DataMiningSubscription(new DataMiningForecaster(dataMMetric), subscriptionOwners);
            this.subscriptionManager.subscribe((Subscription)subscription);
        });
        Logger.LOGGER.inventoryInitialized(predictedMetrics.size());
    }

    public Set<Relationship> predictionRelationships(CanonicalPath ... targetEntity) {
        HashSet<Relationship> result = new HashSet<Relationship>();
        for (CanonicalPath target : targetEntity) {
            Relationship relationship = (Relationship)this.predictionRelationships.relationships().get(target);
            if (relationship == null) continue;
            result.add(relationship);
        }
        return result;
    }

    public Metric metric(CanonicalPath metric) {
        Query query = Query.path().with(new Filter[]{With.path((CanonicalPath)metric), With.type(Metric.class)}).get();
        Page page = this.inventory.execute(query, Metric.class, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
        List metrics = page.toList();
        return metrics.size() > 0 ? (Metric)metrics.get(0) : null;
    }

    public Set<Metric> metricsOfType(CanonicalPath metricType) {
        Query query = Query.path().with(new Filter[]{With.path((CanonicalPath)metricType)}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.defines)}).with(new Filter[]{With.type(Metric.class)}).get();
        Page page = this.inventory.execute(query, Metric.class, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
        List metrics = page.toList();
        return new HashSet<Metric>(metrics);
    }

    public Set<Metric> metricsUnderTenant(CanonicalPath tenant) {
        Set entities = ((Metrics.Multiple)((Metrics.ReadContained)((Feeds.Multiple)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenant.ids().getTenantId())).feeds()).getAll(new Filter[0])).metrics()).getAll(new Filter[0])).entities();
        return entities;
    }

    public void addPredictionRelationship(Relationship relationship) {
        this.predictionRelationships.relationships().put(relationship.getTarget(), relationship);
    }

    public void removePredictionRelationship(Relationship relationship) {
        this.predictionRelationships.relationships().remove(relationship.getTarget());
    }

    private Set<Metric> getAllPredictedMetrics() {
        Set relationships = this.inventory.relationships().named("__inPrediction").entities();
        HashSet<CanonicalPath> metricsCp = new HashSet<CanonicalPath>();
        HashSet<CanonicalPath> metricTypesCp = new HashSet<CanonicalPath>();
        HashSet<CanonicalPath> tenantsCp = new HashSet<CanonicalPath>();
        for (Relationship relationship : relationships) {
            this.predictionRelationships.relationships().put(relationship.getTarget(), relationship);
            if (relationship.getTarget().getSegment().getElementType().equals(Metric.class)) {
                metricsCp.add(relationship.getTarget());
                continue;
            }
            if (relationship.getTarget().getSegment().getElementType().equals(MetricType.class)) {
                metricTypesCp.add(relationship.getTarget());
                continue;
            }
            if (!relationship.getTarget().getSegment().getElementType().equals(Tenant.class)) continue;
            tenantsCp.add(relationship.getTarget());
        }
        Set metrics = ((Metrics.Multiple)((Metrics.ReadContained)((Feeds.Multiple)((Feeds.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feeds()).getAll(new Filter[0])).metrics()).getAll(new Filter[]{With.paths((CanonicalPath[])metricsCp.toArray(new CanonicalPath[0]))})).entities();
        Set metricsUnderTypes = ((Metrics.Multiple)((MetricTypes.Multiple)((MetricTypes.ReadContained)((Feeds.Multiple)((Feeds.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feeds()).getAll(new Filter[0])).metricTypes()).getAll(new Filter[]{With.paths((CanonicalPath[])metricTypesCp.toArray(new CanonicalPath[0]))})).metrics().getAll(new Filter[0])).entities();
        Set metricsUnderTenant = ((Metrics.Multiple)((Metrics.ReadContained)((Feeds.Multiple)((Feeds.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.paths((CanonicalPath[])tenantsCp.toArray(new CanonicalPath[0]))})).feeds()).getAll(new Filter[0])).metrics()).getAll(new Filter[0])).entities();
        metrics.addAll(metricsUnderTypes);
        metrics.addAll(metricsUnderTenant);
        return metrics;
    }
}

