/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.dist.integration.inventory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.datamining.api.Subscription;
import org.hawkular.datamining.api.SubscriptionManager;
import org.hawkular.datamining.api.base.DataMiningForecaster;
import org.hawkular.datamining.api.base.DataMiningSubscription;
import org.hawkular.datamining.api.exception.DataMiningException;
import org.hawkular.datamining.cdi.qualifiers.Eager;
import org.hawkular.datamining.dist.integration.inventory.InventoryStorage;
import org.hawkular.datamining.dist.integration.inventory.InventoryUtil;
import org.hawkular.datamining.dist.integration.inventory.JMSInventoryChangesListener;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.bus.api.InventoryEvent;
import org.hawkular.inventory.bus.api.InventoryEventMessageListener;
import org.hawkular.inventory.bus.api.MetricEvent;
import org.hawkular.inventory.bus.api.MetricTypeEvent;
import org.hawkular.inventory.bus.api.RelationshipEvent;

@Eager
@ApplicationScoped
public class JMSInventoryChangesListener
extends InventoryEventMessageListener {
    @Inject
    private SubscriptionManager subscriptionManager;
    @Inject
    private InventoryStorage inventoryStorage;

    @PostConstruct
    public void init() {
        try {
            InitialContext initialContext = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("java:/HawkularBusConnectionFactory");
            ConnectionContextFactory factory = new ConnectionContextFactory(connectionFactory);
            Endpoint endpoint = new Endpoint(Endpoint.Type.TOPIC, "HawkularInventoryChanges");
            ConsumerConnectionContext consumerConnectionContext = factory.createConsumerConnectionContext(endpoint);
            MessageProcessor processor = new MessageProcessor();
            processor.listen(consumerConnectionContext, (AbstractBasicMessageListener)this);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    protected void onBasicMessage(InventoryEvent<?> inventoryEvent) {
        Action.Enumerated action = inventoryEvent.getAction();
        if (action == Action.Enumerated.REGISTERED || action == Action.Enumerated.COPIED) {
            return;
        }
        try {
            if (inventoryEvent instanceof RelationshipEvent) {
                this.relationshipEvent((Relationship)((RelationshipEvent)inventoryEvent).getObject(), action);
            } else if (inventoryEvent instanceof MetricEvent) {
                this.metricEvent((Metric)((MetricEvent)inventoryEvent).getObject(), action);
            } else if (inventoryEvent instanceof MetricTypeEvent) {
                this.metricTypeEvent((MetricType)((MetricTypeEvent)inventoryEvent).getObject(), action);
            }
        }
        catch (DataMiningException dataMiningException) {
            // empty catch block
        }
    }

    private void relationshipEvent(Relationship relationship, Action.Enumerated action) {
        CanonicalPath target = relationship.getTarget();
        CanonicalPath source = relationship.getSource();
        if (!(source.getSegment().getElementType().equals(Tenant.class) && (target.getSegment().getElementType().equals(Metric.class) || target.getSegment().getElementType().equals(MetricType.class) || target.getSegment().getElementType().equals(Tenant.class)) && relationship.getName().equals("__inPrediction"))) {
            return;
        }
        Long forecastingHorizon = InventoryUtil.parseForecastingHorizon((Relationship)relationship);
        switch (1.$SwitchMap$org$hawkular$inventory$api$Action$Enumerated[action.ordinal()]) {
            case 1: {
                this.inventoryStorage.addPredictionRelationship(relationship);
                if (target.getSegment().getElementType().equals(Metric.class)) {
                    Metric invMetric2 = this.inventoryStorage.metric(target);
                    if (this.subscriptionManager.isSubscribed(invMetric2.getPath().ids().getTenantId(), invMetric2.getId())) {
                        Subscription subscription = this.subscriptionManager.subscription(invMetric2.getPath().ids().getTenantId(), invMetric2.getId());
                        subscription.addSubscriptionOwner(Subscription.SubscriptionOwner.Metric);
                        subscription.forecaster().context().setForecastingHorizon(forecastingHorizon);
                        break;
                    }
                    org.hawkular.datamining.api.model.Metric dataminingMetric = InventoryUtil.convertMetric((Metric)invMetric2, (Long)forecastingHorizon);
                    DataMiningSubscription subscription = new DataMiningSubscription(new DataMiningForecaster(dataminingMetric), new HashSet<Subscription.SubscriptionOwner>(Arrays.asList(Subscription.SubscriptionOwner.Metric)));
                    this.subscriptionManager.subscribe((Subscription)subscription);
                    break;
                }
                if (target.getSegment().getElementType().equals(MetricType.class)) {
                    Set invMetrics = this.inventoryStorage.metricsOfType(target);
                    invMetrics.forEach(invMetric -> {
                        if (this.subscriptionManager.isSubscribed(invMetric.getPath().ids().getTenantId(), invMetric.getId())) {
                            Subscription subscription = this.subscriptionManager.subscription(invMetric.getPath().ids().getTenantId(), invMetric.getId());
                            if (!subscription.getSubscriptionOwners().contains(Subscription.SubscriptionOwner.Metric)) {
                                subscription.forecaster().context().setForecastingHorizon(forecastingHorizon);
                            }
                            subscription.addSubscriptionOwner(Subscription.SubscriptionOwner.MetricType);
                        } else {
                            org.hawkular.datamining.api.model.Metric dataminingMetric = InventoryUtil.convertMetric((Metric)invMetric, (Long)forecastingHorizon);
                            DataMiningSubscription subscription = new DataMiningSubscription(new DataMiningForecaster(dataminingMetric), new HashSet<Subscription.SubscriptionOwner>(Arrays.asList(Subscription.SubscriptionOwner.MetricType)));
                            this.subscriptionManager.subscribe((Subscription)subscription);
                        }
                    });
                    break;
                }
                CanonicalPath tenant = relationship.getTarget();
                Set metricsUnderTenant = this.inventoryStorage.metricsUnderTenant(tenant);
                metricsUnderTenant.forEach(invMetric -> {
                    if (this.subscriptionManager.isSubscribed(invMetric.getPath().ids().getTenantId(), invMetric.getId())) {
                        Subscription subscription = this.subscriptionManager.subscription(invMetric.getPath().ids().getTenantId(), invMetric.getId());
                        if (!subscription.getSubscriptionOwners().containsAll(Arrays.asList(Subscription.SubscriptionOwner.Metric, Subscription.SubscriptionOwner.MetricType))) {
                            subscription.forecaster().context().setForecastingHorizon(forecastingHorizon);
                        }
                        subscription.addSubscriptionOwner(Subscription.SubscriptionOwner.Tenant);
                    } else {
                        org.hawkular.datamining.api.model.Metric dataminingMetric = InventoryUtil.convertMetric((Metric)invMetric, (Long)forecastingHorizon);
                        DataMiningSubscription subscription = new DataMiningSubscription(new DataMiningForecaster(dataminingMetric), new HashSet<Subscription.SubscriptionOwner>(Arrays.asList(Subscription.SubscriptionOwner.Tenant)));
                        this.subscriptionManager.subscribe((Subscription)subscription);
                    }
                });
                break;
            }
            case 2: {
                Subscription.SubscriptionOwner owner;
                HashSet<Metric> metricsToRemove;
                this.inventoryStorage.removePredictionRelationship(relationship);
                if (target.getSegment().getElementType().equals(Metric.class)) {
                    metricsToRemove = new HashSet<Metric>(Arrays.asList(this.inventoryStorage.metric(target)));
                    owner = Subscription.SubscriptionOwner.Metric;
                } else if (target.getSegment().getElementType().equals(MetricType.class)) {
                    metricsToRemove = this.inventoryStorage.metricsOfType(target);
                    owner = Subscription.SubscriptionOwner.MetricType;
                } else {
                    metricsToRemove = this.inventoryStorage.metricsUnderTenant(target);
                    owner = Subscription.SubscriptionOwner.Tenant;
                }
                metricsToRemove.forEach(invMetric -> {
                    Set relationships = this.inventoryStorage.predictionRelationships(new CanonicalPath[]{invMetric.getPath(), invMetric.getType().getPath(), invMetric.getPath().getRoot()});
                    Long horizon = InventoryUtil.closestForecastingHorizon((Set)relationships);
                    this.subscriptionManager.subscription(invMetric.getPath().ids().getTenantId(), invMetric.getId()).forecaster().context().setForecastingHorizon(horizon);
                    this.subscriptionManager.unsubscribe(invMetric.getPath().ids().getTenantId(), invMetric.getId(), owner);
                });
                break;
            }
        }
    }

    private void metricEvent(Metric metric, Action.Enumerated action) {
        CanonicalPath tenant = metric.getPath().getRoot();
        Set predictionRelationships = this.inventoryStorage.predictionRelationships(new CanonicalPath[]{metric.getPath(), metric.getType().getPath(), tenant});
        if (predictionRelationships.isEmpty()) {
            return;
        }
        switch (1.$SwitchMap$org$hawkular$inventory$api$Action$Enumerated[action.ordinal()]) {
            case 1: {
                Long forecastingHorizon = InventoryUtil.closestForecastingHorizon((Set)predictionRelationships);
                org.hawkular.datamining.api.model.Metric dataminingMetric = InventoryUtil.convertMetric((Metric)metric, (Long)forecastingHorizon);
                DataMiningSubscription subscription = new DataMiningSubscription(new DataMiningForecaster(dataminingMetric), InventoryUtil.predictionRelationshipsToOwners((Set)predictionRelationships));
                this.subscriptionManager.subscribe((Subscription)subscription);
                break;
            }
            case 3: {
                Subscription subscription = this.subscriptionManager.subscription(metric.getPath().ids().getTenantId(), metric.getId());
                ((org.hawkular.datamining.api.model.Metric)subscription.getMetric()).getMetricType().setCollectionInterval(metric.getCollectionInterval());
                break;
            }
            case 2: {
                this.subscriptionManager.unsubscribe(metric.getPath().ids().getTenantId(), metric.getId(), Subscription.SubscriptionOwner.Metric);
            }
        }
    }

    private void metricTypeEvent(MetricType metricType, Action.Enumerated action) {
        if (action == Action.Enumerated.CREATED) {
            return;
        }
        CanonicalPath tenant = metricType.getPath().getRoot();
        Set predictionRelationships = this.inventoryStorage.predictionRelationships(new CanonicalPath[]{metricType.getPath(), tenant});
        if (predictionRelationships.isEmpty()) {
            return;
        }
        switch (1.$SwitchMap$org$hawkular$inventory$api$Action$Enumerated[action.ordinal()]) {
            case 3: {
                Set metricsOfType = this.inventoryStorage.metricsOfType(metricType.getPath());
                metricsOfType.forEach(metric -> {
                    if (this.subscriptionManager.isSubscribed(metric.getPath().ids().getTenantId(), metric.getId())) {
                        org.hawkular.datamining.api.model.Metric metricc = (org.hawkular.datamining.api.model.Metric)this.subscriptionManager.subscription(metric.getPath().ids().getTenantId(), metric.getId()).getMetric();
                        metricc.setCollectionInterval(metric.getType().getCollectionInterval());
                    }
                });
                break;
            }
            case 2: {
                Set metrics = this.inventoryStorage.metricsOfType(metricType.getPath());
                metrics.forEach(metric -> this.subscriptionManager.unsubscribeAll(metric.getPath().ids().getTenantId(), metric.getId()));
            }
        }
    }
}

