/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.dist.integration.metrics;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.hawkular.datamining.api.model.BucketPoint;
import org.hawkular.datamining.api.storage.MetricsClient;
import org.hawkular.datamining.dist.Logger;
import org.hawkular.datamining.forecast.DataPoint;

/*
 * Exception performing whole class analysis ignored.
 */
@Alternative
@ApplicationScoped
public class RestMetricsClient
implements MetricsClient {
    private String BASE_URL = "http://localhost:8080/hawkular/metrics";
    private final OkHttpClient okHttpClient = new OkHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RestMetricsClient() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public List<DataPoint> loadPoints(String metricId, String tenant) {
        String url = null;
        try {
            url = this.BASE_URL + "/gauges/" + RestMetricsClient.encodeUrlPath((String)metricId) + "/data?start=1";
        }
        catch (UnsupportedEncodingException e) {
            Logger.LOGGER.errorf("Cannot encode URL for metric: %s", (Object)metricId);
            return Collections.emptyList();
        }
        Request request = RestMetricsClient.buildJsonRequest((String)url, Collections.singletonMap("Hawkular-Tenant", tenant));
        List result = (List)this.execute(request, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public List<BucketPoint> loadBuckets(long buckets, String metricId, String tenant) {
        String url = null;
        try {
            url = this.BASE_URL + "/gauges/" + RestMetricsClient.encodeUrlPath((String)metricId) + "/data?start=1&buckets=" + buckets;
        }
        catch (UnsupportedEncodingException e) {
            Logger.LOGGER.errorf("Cannot encode URL for metric: %s", (Object)metricId);
            return Collections.emptyList();
        }
        Request request = RestMetricsClient.buildJsonRequest((String)url, Collections.singletonMap("Hawkular-Tenant", tenant));
        List result = (List)this.execute(request, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private <T> T execute(Request request, TypeReference<T> type) {
        Object result = Collections.emptyList();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                Logger.LOGGER.errorf("Unsuccessful REST request to metrics, url = %s", (Object)request.url());
            }
            if (response.code() == 204) {
                return (T)result;
            }
            String responseBody = response.body().string();
            result = this.objectMapper.readValue(responseBody, type);
        }
        catch (IOException e) {
            Logger.LOGGER.failedToLoadMetricData(request.url().toString(), e.getMessage());
        }
        return (T)result;
    }

    private static String encodeUrlPath(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF-8").replace("+", "%20");
    }

    private static Request buildJsonRequest(String url, Map<String, String> headers) {
        Request.Builder reqBuilder = new Request.Builder().url(url).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                reqBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return reqBuilder.get().build();
    }
}

