/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.dist.integration.inventory;

import java.util.HashSet;
import java.util.Set;
import org.hawkular.datamining.api.Subscription;
import org.hawkular.datamining.api.model.MetricDataType;
import org.hawkular.datamining.dist.integration.inventory.InventoryUtil;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;

/*
 * Exception performing whole class analysis ignored.
 */
public class InventoryUtil {
    private InventoryUtil() {
    }

    public static org.hawkular.datamining.api.model.MetricType convertMetricType(MetricType type) {
        MetricDataType dataType = InventoryUtil.convertDataType((org.hawkular.inventory.api.model.MetricDataType)type.getType());
        return new org.hawkular.datamining.api.model.MetricType(type.getPath().ids().getTenantId(), type.getCollectionInterval(), dataType);
    }

    public static org.hawkular.datamining.api.model.Metric convertMetric(Metric metric, Long forecastingHorizon) {
        org.hawkular.datamining.api.model.MetricType type = InventoryUtil.convertMetricType((MetricType)metric.getType());
        return new org.hawkular.datamining.api.model.Metric(metric.getPath().ids().getTenantId(), metric.getPath().ids().getFeedId(), metric.getId(), metric.getCollectionInterval(), forecastingHorizon, type);
    }

    public static Long parseForecastingHorizon(Relationship relationship) {
        if (relationship == null) {
            return 0L;
        }
        String forecastingHorizonObject = (String)relationship.getProperties().get("forecastingHorizon");
        return forecastingHorizonObject == null ? 0L : Long.parseLong(forecastingHorizonObject);
    }

    public static Set<Subscription.SubscriptionOwner> predictionRelationshipsToOwners(Set<Relationship> relationships) {
        HashSet<Subscription.SubscriptionOwner> subscriptionOwners = new HashSet<Subscription.SubscriptionOwner>();
        for (Relationship relationship : relationships) {
            Class targetEntity = relationship.getTarget().getSegment().getElementType();
            if (targetEntity.equals(Metric.class)) {
                subscriptionOwners.add(Subscription.SubscriptionOwner.Metric);
                continue;
            }
            if (targetEntity.equals(MetricType.class)) {
                subscriptionOwners.add(Subscription.SubscriptionOwner.MetricType);
                continue;
            }
            if (!targetEntity.equals(Tenant.class)) continue;
            subscriptionOwners.add(Subscription.SubscriptionOwner.Tenant);
        }
        return subscriptionOwners;
    }

    public static Subscription.SubscriptionOwner parseSubscriptionOwner(CanonicalPath canonicalPath) {
        Class entity = canonicalPath.getSegment().getElementType();
        if (entity.equals(Tenant.class)) {
            return Subscription.SubscriptionOwner.Tenant;
        }
        if (entity.equals(MetricType.class)) {
            return Subscription.SubscriptionOwner.MetricType;
        }
        if (entity.equals(Metric.class)) {
            return Subscription.SubscriptionOwner.Metric;
        }
        return null;
    }

    public static Long closestForecastingHorizon(Set<Relationship> relationships) {
        Relationship closestRelationship = null;
        for (Relationship rel : relationships) {
            Class target = rel.getTarget().getSegment().getElementType();
            if (target.equals(Metric.class)) {
                closestRelationship = rel;
                continue;
            }
            if (target.equals(MetricType.class) && (closestRelationship == null || closestRelationship.getTarget().getSegment().getElementType().equals(Tenant.class))) {
                closestRelationship = rel;
                continue;
            }
            if (!target.equals(Tenant.class) || closestRelationship != null) continue;
            closestRelationship = rel;
        }
        if (closestRelationship == null) {
            return 0L;
        }
        return InventoryUtil.parseForecastingHorizon(closestRelationship);
    }

    public static MetricDataType convertDataType(org.hawkular.inventory.api.model.MetricDataType dataType) {
        MetricDataType dataMiningType = null;
        switch (1.$SwitchMap$org$hawkular$inventory$api$model$MetricDataType[dataType.ordinal()]) {
            case 1: {
                dataMiningType = MetricDataType.AVAILABILITY;
                break;
            }
            case 2: {
                dataMiningType = MetricDataType.COUNTER;
                break;
            }
            case 3: {
                dataMiningType = MetricDataType.COUNTER_RATE;
                break;
            }
            default: {
                dataMiningType = MetricDataType.GAUGE;
            }
        }
        return dataMiningType;
    }
}

