/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.dist.integration.metrics;

import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.bus.api.MetricDataMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.datamining.api.PredictionListener;
import org.hawkular.datamining.dist.Logger;
import org.hawkular.datamining.forecast.DataPoint;

public class JMSPredictionSender
implements PredictionListener {
    private final String topicName;
    private final MessageProcessor messageProcessor;
    private ConnectionFactory connectionFactory;

    public JMSPredictionSender(String topicName) {
        this.topicName = topicName;
        this.messageProcessor = new MessageProcessor();
        try {
            InitialContext initialContext = new InitialContext();
            this.connectionFactory = (ConnectionFactory)initialContext.lookup("java:/HawkularBusConnectionFactory");
        }
        catch (NamingException ex) {
            Logger.LOGGER.errorf("Could not initialize naming context, exception: %s", (Object)ex);
        }
    }

    public void send(List<DataPoint> predictedPoints, String tenant, String metricId) {
        MetricDataMessage message = this.convertToMessage(predictedPoints, tenant, "prediction_" + metricId);
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(this.connectionFactory);){
            ProducerConnectionContext producerConnectionContext = ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, this.topicName));
            this.messageProcessor.send(producerConnectionContext, (BasicMessage)message);
            Logger.LOGGER.tracef("Sent message %s with headers %s to %s", (Object)message, (Object)producerConnectionContext.getDestination());
        }
        catch (JMSException ex) {
            Logger.LOGGER.failedToSendMessage(ex.getMessage());
        }
    }

    private MetricDataMessage convertToMessage(List<DataPoint> points, String tenant, String metricId) {
        List singleMetrics = this.dataPointToSingleMetric(points, metricId);
        MetricDataMessage.MetricData metricData = new MetricDataMessage.MetricData();
        metricData.setTenantId(tenant);
        metricData.setData(singleMetrics);
        MetricDataMessage metricDataMessage = new MetricDataMessage(metricData);
        return metricDataMessage;
    }

    public List<MetricDataMessage.SingleMetric> dataPointToSingleMetric(List<DataPoint> dataPoints, String metricId) {
        ArrayList<MetricDataMessage.SingleMetric> singleMetrics = new ArrayList<MetricDataMessage.SingleMetric>(dataPoints.size());
        for (DataPoint point : dataPoints) {
            singleMetrics.add(new MetricDataMessage.SingleMetric(metricId, point.getTimestamp().longValue(), point.getValue().doubleValue()));
        }
        return singleMetrics;
    }
}

