/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accesportal.backend.control;

import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class RedHatAccessConfiguration {
    private int sessionTimeout = 3000000;
    private boolean brokered = true;
    private boolean devel = false;
    private String userAgent = "redhat-access-plugin-hawkular-1.0.4";
    private String url = "https://api.access.redhat.com";
    private String proxyUser;
    private String proxyPassword;
    private URL proxyUrl;
    private int proxyPort;

    public RedHatAccessConfiguration() throws MalformedURLException {
        String value = System.getProperty("http.proxyUser");
        if (value != null && !value.isEmpty()) {
            this.proxyUser = value;
        }
        if ((value = System.getProperty("http.proxyPassword")) != null && !value.isEmpty()) {
            this.proxyPassword = value;
        }
        if ((value = System.getProperty("http.proxyPort")) != null && !value.isEmpty()) {
            this.proxyPort = Integer.parseInt(value);
        }
        if ((value = System.getProperty("http.proxyHost")) != null && !value.isEmpty()) {
            this.proxyUrl = new URL(value);
        }
    }

    public boolean isBrokered() {
        return this.brokered;
    }

    public boolean isDevel() {
        return this.devel;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public URL getProxyUrl() {
        return this.proxyUrl;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }
}

