/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accesportal.backend.boundary;

import com.redhat.gss.redhat_support_lib.api.API;
import java.io.File;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.accesportal.backend.control.JDRLocalReport;
import org.hawkular.accesportal.backend.control.RedHatAccessConfiguration;
import org.hawkular.accesportal.backend.entity.SelectedFileForUpload;

@Path(value="/attachments")
public class AttachmentEndpoint {
    private static final String SERVER_REPORT = "Hawkular Server JDR Report";
    @Inject
    RedHatAccessConfiguration configuration;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response getAvailableAttachments() {
        return Response.ok((Object)"Hawkular Server JDR Report?checked=true\n").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response uploadFilesToCase(SelectedFileForUpload selectedFileForUpload) throws Exception {
        API api = new API(selectedFileForUpload.getUsername(), selectedFileForUpload.getPassword(), this.configuration.getUrl(), this.configuration.getProxyUser(), this.configuration.getProxyPassword(), this.configuration.getProxyUrl(), this.configuration.getProxyPort(), this.configuration.getUserAgent(), this.configuration.isDevel());
        api.getProblems().diagnoseStr("test");
        if (SERVER_REPORT.equalsIgnoreCase(selectedFileForUpload.getAttachment())) {
            String report = new JDRLocalReport().getReportLocation();
            try {
                api.getAttachments().add(selectedFileForUpload.getCaseNum(), true, report, selectedFileForUpload.getAttachment());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean bl = new File(report).delete();
        }
        return null;
    }
}

