/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.hawkular.rest.RestApiLogger;
import org.hawkular.rx.cdi.JacksonConfig;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;

@Provider
@ServerInterceptor
public class LoggingInterceptor
implements ContainerRequestFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (RestApiLogger.REQUESTS_LOGGER.isDebugEnabled()) {
            String method = containerRequestContext.getMethod();
            String url = containerRequestContext.getUriInfo().getRequestUri().toString();
            StringBuilder headersStr = new StringBuilder();
            MultivaluedMap headers = containerRequestContext.getHeaders();
            for (Map.Entry header : headers.entrySet()) {
                headersStr.append((String)header.getKey()).append(": ").append(header.getValue()).append('\n');
            }
            String json = null;
            if ("POST".equals(method) || "PUT".equals(method)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)containerRequestContext.getEntityStream(), (OutputStream)baos);
                byte[] jsonBytes = baos.toByteArray();
                json = new String(jsonBytes, "UTF-8");
                Object jsonObject = MAPPER.readValue(json, Object.class);
                json = MAPPER.writeValueAsString(jsonObject);
                containerRequestContext.setEntityStream((InputStream)new ByteArrayInputStream(jsonBytes));
            }
            PostMatchContainerRequestContext pmContext = (PostMatchContainerRequestContext)containerRequestContext;
            Method javaMethod = pmContext.getResourceMethod().getMethod();
            RestApiLogger.REQUESTS_LOGGER.restCall(method, url, headersStr.toString(), json == null ? "empty" : json, javaMethod.toGenericString());
        }
    }

    static {
        JacksonConfig.initializeObjectMapper((ObjectMapper)MAPPER);
    }
}

