/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest.api.v1.interfaces;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.hawkular.rest.api.v1.entities.URL;
import org.hawkular.rest.json.ApiError;

@Path(value="/urls")
@Produces(value={"application/hawkular.1.0.0+json"})
@Consumes(value={"application/json"})
@Api(value="/urls", description="Work with the URLs of the current persona")
public interface RestURL {
    @GET
    @Path(value="{urlId}")
    @ApiOperation(value="Retrieves the URL of the currently logged in persona")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public void getUrl(@Suspended AsyncResponse var1, @PathParam(value="urlId") String var2, @HeaderParam(value="Authorization") String var3);

    @GET
    @ApiOperation(value="Retrieves all URLs of the currently logged in persona")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public void getAll(@Suspended AsyncResponse var1, @HeaderParam(value="Authorization") String var2);

    @POST
    @Path(value="/")
    @ApiOperation(value="Creates the URL of the currently logged in persona")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public void createUrl(@Suspended AsyncResponse var1, @ApiParam(required=true) URL var2, @HeaderParam(value="Authorization") String var3);

    @PUT
    @Path(value="/")
    @ApiOperation(value="Updates properties of the URL")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public void updateUrl(@Suspended AsyncResponse var1, @PathParam(value="urlId") String var2, @ApiParam(required=true) URL var3, @HeaderParam(value="Authorization") String var4);

    @DELETE
    @Path(value="/")
    @ApiOperation(value="Deletes the URL and all its data")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public void deleteUrl(@Suspended AsyncResponse var1, @PathParam(value="urlId") String var2, @HeaderParam(value="Authorization") String var3);
}

