/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.commands.hawkular;

import com.netflix.hystrix.HystrixCommandGroupKey;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hawkular.rx.cdi.Initialized;
import org.hawkular.rx.cdi.WithValues;
import org.hawkular.rx.commands.common.AbstractHttpCommand;
import org.hawkular.rx.commands.common.HawkularConfiguration;
import org.hawkular.rx.commands.inventory.DeleteMetricCommand;
import org.hawkular.rx.commands.inventory.DeleteResourceCommand;
import org.hawkular.rx.httpclient.HttpClient;
import rx.Observable;
import rx.Subscriber;

@WithValues
public class DeleteUrlCommand
extends AbstractHttpCommand<String> {
    protected String urlId;
    protected String authToken;
    protected String persona;
    @Inject
    protected HttpClient client;
    @Inject
    protected HawkularConfiguration config;
    @Inject
    @Any
    private Instance<DeleteResourceCommand> deleteResourceCommandInjector;
    @Inject
    @Any
    private Instance<DeleteMetricCommand> deleteMetricCommandInjector;

    @Override
    protected List<ImmutablePair<Class, Consumer>> getSetters() {
        return Arrays.asList(new ImmutablePair(String.class, x -> {
            this.urlId = this.nullOrStr(x);
        }), new ImmutablePair(String.class, x -> {
            this.authToken = this.nullOrStr(x);
        }), new ImmutablePair(String.class, x -> {
            this.persona = this.nullOrStr(x);
        }));
    }

    @Inject
    protected DeleteUrlCommand(InjectionPoint ip) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"URL"));
        this.initialize(ip);
    }

    protected Observable<String> construct() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(Subscriber<? super String> observer) {
                if (observer.isUnsubscribed()) {
                    return;
                }
                try {
                    String metric1Id = DeleteUrlCommand.this.urlId + ".status.duration";
                    String metric2Id = DeleteUrlCommand.this.urlId + ".status.code";
                    DeleteMetricCommand deleteMetric1Cmd = (DeleteMetricCommand)((Object)DeleteUrlCommand.this.deleteMetricCommandInjector.select(new Annotation[]{Initialized.withValues(metric1Id, DeleteUrlCommand.this.authToken, DeleteUrlCommand.this.persona)}).get());
                    deleteMetric1Cmd.setResourcePath(DeleteUrlCommand.this.urlId);
                    DeleteMetricCommand deleteMetric2Cmd = (DeleteMetricCommand)((Object)DeleteUrlCommand.this.deleteMetricCommandInjector.select(new Annotation[]{Initialized.withValues(metric2Id, DeleteUrlCommand.this.authToken, DeleteUrlCommand.this.persona)}).get());
                    deleteMetric2Cmd.setResourcePath(DeleteUrlCommand.this.urlId);
                    DeleteResourceCommand deleteResourceCmd = (DeleteResourceCommand)((Object)DeleteUrlCommand.this.deleteResourceCommandInjector.select(new Annotation[]{Initialized.withValues(DeleteUrlCommand.this.urlId, DeleteUrlCommand.this.authToken, DeleteUrlCommand.this.persona)}).get());
                    Observable observeCmd1 = deleteMetric1Cmd.toObservable();
                    Observable observeCmd2 = deleteMetric2Cmd.toObservable();
                    Observable observeDeleteResource = deleteResourceCmd.toObservable();
                    observeCmd1.zipWith(observeCmd2, (first, second) -> new ImmutablePair(first, second)).flatMap(pair -> observeDeleteResource).subscribe(resourceDeletedResponse -> {
                        observer.onNext(resourceDeletedResponse);
                        observer.onCompleted();
                    });
                }
                catch (Exception e) {
                    observer.onError((Throwable)e);
                }
            }
        });
    }

    protected Observable<String> resumeWithFallback() {
        return Observable.just((Object)this.urlId);
    }
}

