/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.commands.hawkular;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.rx.cdi.CreateCommand;
import org.hawkular.rx.cdi.Initialized;
import org.hawkular.rx.cdi.WithValues;
import org.hawkular.rx.commands.common.AbstractHttpCommand;
import org.hawkular.rx.commands.common.HawkularConfiguration;
import org.hawkular.rx.commands.inventory.CreateMetricCommand;
import org.hawkular.rx.commands.inventory.CreateResourceCommand;
import org.hawkular.rx.httpclient.HttpClient;
import rx.Observable;
import rx.Subscriber;

@WithValues
@CreateCommand
public class CreateUrlCommand
extends AbstractHttpCommand<String> {
    protected String url;
    protected String authToken;
    protected String persona;
    @Inject
    protected HttpClient client;
    @Inject
    @Any
    protected ObjectMapper mapper;
    @Inject
    private MessageDigest md5;
    @Inject
    protected HawkularConfiguration config;
    @Inject
    @Any
    private Instance<CreateResourceCommand> createResourceCommandInjector;
    @Inject
    @Any
    private Instance<CreateMetricCommand> createMetricCommandInjector;

    @Override
    protected List<ImmutablePair<Class, Consumer>> getSetters() {
        return Arrays.asList(new ImmutablePair(String.class, x -> {
            this.url = this.makeUrlWithProtocol(this.nullOrStr(x));
        }), new ImmutablePair(String.class, x -> {
            this.authToken = this.nullOrStr(x);
        }), new ImmutablePair(String.class, x -> {
            this.persona = this.nullOrStr(x);
        }));
    }

    @Inject
    protected CreateUrlCommand(InjectionPoint ip) {
        super(HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"URL")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(3500)));
        this.initialize(ip);
    }

    protected Observable<String> construct() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(Subscriber<? super String> observer) {
                try {
                    if (observer.isUnsubscribed()) {
                        return;
                    }
                    CreateResourceCommand createResourceCmd = (CreateResourceCommand)((Object)CreateUrlCommand.this.createResourceCommandInjector.select(new Annotation[]{Initialized.withValues(CreateUrlCommand.this.authToken, CreateUrlCommand.this.persona)}).get());
                    String hashedUrl = CreateUrlCommand.this.md5Hash(CreateUrlCommand.this.url);
                    Resource.Blueprint urlBlueprint = ((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId(hashedUrl)).withResourceTypePath(((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(CreateUrlCommand.this.persona)).resourceType("URL")).get()).toString()).withProperty("url", (Object)CreateUrlCommand.this.url)).withProperty("hwk-gui-domainSort", (Object)CreateUrlCommand.this.getDomainSorterUrl(CreateUrlCommand.this.url))).build();
                    createResourceCmd.setResource(urlBlueprint);
                    Observable observeResource = createResourceCmd.toObservable();
                    Metric.Blueprint metric1 = ((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId(hashedUrl + ".status.duration")).withMetricTypePath(((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(CreateUrlCommand.this.persona)).metricType("status.duration.type")).get()).toString()).build();
                    CreateMetricCommand metric1Cmd = (CreateMetricCommand)((Object)CreateUrlCommand.this.createMetricCommandInjector.select(new Annotation[]{Initialized.withValues(CreateUrlCommand.this.authToken, CreateUrlCommand.this.persona)}).get());
                    metric1Cmd.setResourcePath(hashedUrl);
                    metric1Cmd.setMetric(metric1);
                    Metric.Blueprint metric2 = ((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId(hashedUrl + ".status.code")).withMetricTypePath(((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(CreateUrlCommand.this.persona)).metricType("status.code.type")).get()).toString()).build();
                    CreateMetricCommand metric2Cmd = (CreateMetricCommand)((Object)CreateUrlCommand.this.createMetricCommandInjector.select(new Annotation[]{Initialized.withValues(CreateUrlCommand.this.authToken, CreateUrlCommand.this.persona)}).get());
                    metric2Cmd.setResourcePath(hashedUrl);
                    metric2Cmd.setMetric(metric2);
                    Observable observeMetric1 = metric1Cmd.toObservable();
                    Observable observeMetric2 = metric2Cmd.toObservable();
                    observeResource.concatWith(observeMetric1.mergeWith(observeMetric2)).buffer(3).doOnError(e -> {
                        System.err.println(e);
                        observer.onError(e);
                    }).subscribe(commandResponse -> {
                        observer.onNext(commandResponse.get(0));
                        observer.onCompleted();
                    });
                }
                catch (Exception e2) {
                    observer.onError((Throwable)e2);
                }
            }
        });
    }

    private String md5Hash(String input) {
        byte[] byteData = this.md5.digest(input.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    protected String makeUrlWithProtocol(String url) {
        return url.startsWith("http") ? url : "http://" + url;
    }

    protected String getDomainSorterUrl(String url) {
        try {
            URL urlInstance = new URL(url);
            String[] levels = urlInstance.getHost().split(".");
            if (levels != null && levels.length > 1) {
                Object[] levelsSorted = new String[levels.length];
                Arrays.setAll(levelsSorted, i -> {
                    switch (i) {
                        case 0: 
                        case 1: {
                            String level = levels[levels.length - 1 - i];
                            return "www".equals(level) ? " " : level;
                        }
                    }
                    String level = levels[i];
                    return "www".equals(level) ? " " : level;
                });
                return StringUtils.join((Object[])levelsSorted, (String)".");
            }
            return url;
        }
        catch (MalformedURLException e) {
            return url;
        }
    }
}

