/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.httpclient;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import javax.enterprise.inject.Default;
import org.hawkular.rx.httpclient.HttpClient;
import org.hawkular.rx.httpclient.RestResponse;

@Default
public class OkClient
implements HttpClient {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient delegatingClient = new OkHttpClient();

    @Override
    public RestResponse post(String authToken, String persona, String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).addHeader("Authorization", authToken).addHeader("Hawkular-Persona", persona).post(body).build();
        Response response = this.delegatingClient.newCall(request).execute();
        return new RestResponse(response);
    }

    @Override
    public RestResponse get(String authToken, String persona, String url) throws IOException {
        Request request = new Request.Builder().url(url).addHeader("Authorization", authToken).addHeader("Hawkular-Persona", persona).get().build();
        Response response = this.delegatingClient.newCall(request).execute();
        return new RestResponse(response);
    }

    @Override
    public RestResponse put(String authToken, String persona, String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).addHeader("Authorization", authToken).addHeader("Hawkular-Persona", persona).put(body).build();
        Response response = this.delegatingClient.newCall(request).execute();
        return new RestResponse(response);
    }

    @Override
    public RestResponse delete(String authToken, String persona, String url) throws IOException {
        Request request = new Request.Builder().url(url).addHeader("Authorization", authToken).addHeader("Hawkular-Persona", persona).delete().build();
        Response response = this.delegatingClient.newCall(request).execute();
        return new RestResponse(response);
    }
}

