/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.core.api.AvailabilityType;
import org.hawkular.metrics.core.api.DataPoint;

@ApiModel(description="Consists of a timestamp and a value where supported values are \"up\" and \"down\"")
public class AvailabilityDataPoint {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private long timestamp;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String value;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Map<String, String> tags = Collections.emptyMap();

    private AvailabilityDataPoint() {
    }

    public AvailabilityDataPoint(DataPoint<AvailabilityType> dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = ((AvailabilityType)dataPoint.getValue()).getText().toLowerCase();
        this.tags = dataPoint.getTags();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getValue() {
        return this.value.toLowerCase();
    }

    public Map<String, String> getTags() {
        return ImmutableMap.copyOf(this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailabilityDataPoint dataPoint = (AvailabilityDataPoint)o;
        return Objects.equals(this.timestamp, dataPoint.timestamp) && Objects.equals(this.value, dataPoint.value);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", (Object)this.value).add("tags", this.tags).toString();
    }
}

