/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Availability;
import org.hawkular.metrics.api.jaxrs.model.AvailabilityDataPoint;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.CounterDataPoint;
import org.hawkular.metrics.api.jaxrs.model.Gauge;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.core.api.AvailabilityType;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ApiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ApiUtils.class);

    private ApiUtils() {
    }

    public static Response collectionToResponse(Collection<?> collection) {
        return collection.isEmpty() ? ApiUtils.noContent() : Response.ok(collection).type("application/json").build();
    }

    public static Response serverError(Throwable t, String message) {
        LOG.trace("Server error response", t);
        String errorMsg = message + ": " + Throwables.getRootCause((Throwable)t).getMessage();
        return Response.serverError().type("application/json").entity((Object)new ApiError(errorMsg)).build();
    }

    public static Response serverError(Throwable t) {
        return ApiUtils.serverError(t, "Failed to perform operation due to an error");
    }

    public static <E> Response simpleOKResponse(E optional) {
        return Response.ok().build();
    }

    public static Response valueToResponse(Optional<?> optional) {
        return optional.map(value -> Response.ok((Object)value).build()).orElse(ApiUtils.noContent());
    }

    public static List<DataPoint<Double>> requestToGaugeDataPoints(List<GaugeDataPoint> gaugeDataPoints) {
        return gaugeDataPoints.stream().map(p -> new DataPoint(p.getTimestamp(), (Object)p.getValue(), p.getTags())).collect(Collectors.toList());
    }

    public static Observable<Metric<Double>> requestToGauges(String tenantId, List<Gauge> gauges) {
        return Observable.from(gauges).map(g -> new Metric(new MetricId(tenantId, MetricType.GAUGE, g.getId()), ApiUtils.requestToGaugeDataPoints(g.getData())));
    }

    public static Observable<Metric<Long>> requestToCounters(String tenantId, List<Counter> counters) {
        return Observable.from(counters).map(c -> new Metric(new MetricId(tenantId, MetricType.COUNTER, c.getId()), ApiUtils.requestToCounterDataPoints(c.getData())));
    }

    public static Observable<Metric<AvailabilityType>> requestToAvailabilities(String tenantId, List<Availability> avails) {
        return Observable.from(avails).map(a -> new Metric(new MetricId(tenantId, MetricType.AVAILABILITY, a.getId()), ApiUtils.requestToAvailabilityDataPoints(a.getData())));
    }

    public static List<DataPoint<Long>> requestToCounterDataPoints(List<CounterDataPoint> dataPoints) {
        return dataPoints.stream().map(p -> new DataPoint(p.getTimestamp(), (Object)p.getValue(), p.getTags())).collect(Collectors.toList());
    }

    public static List<DataPoint<AvailabilityType>> requestToAvailabilityDataPoints(List<AvailabilityDataPoint> dataPoints) {
        return dataPoints.stream().map(p -> new DataPoint(p.getTimestamp(), (Object)AvailabilityType.fromString((String)p.getValue()))).collect(Collectors.toList());
    }

    public static Response noContent() {
        return Response.noContent().build();
    }

    public static Response emptyPayload() {
        return ApiUtils.badRequest(new ApiError("Payload is empty"));
    }

    public static Response badRequest(ApiError error) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    public static Response badRequest(Throwable t) {
        ApiError error = new ApiError(t.getLocalizedMessage());
        return ApiUtils.badRequest(error);
    }
}

