/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.api.jaxrs.codehaus.jackson.MetricTypeKeySerializer;
import org.hawkular.metrics.api.jaxrs.fasterxml.jackson.MetricTypeKeyDeserializer;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.Tenant;

@ApiModel(value="Tenant", description="The definition of a tenant")
public class TenantDefinition {
    private final String id;
    private final Map<MetricType<?>, Integer> retentionSettings;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @org.codehaus.jackson.annotate.JsonCreator
    public TenantDefinition(@JsonProperty(value="id") @org.codehaus.jackson.annotate.JsonProperty(value="id") String id, @JsonProperty(value="retentions") @com.fasterxml.jackson.databind.annotation.JsonDeserialize(keyUsing=MetricTypeKeyDeserializer.class) @org.codehaus.jackson.annotate.JsonProperty(value="retentions") Map<MetricType<?>, Integer> retentionSettings) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Tenant id is null");
        this.id = id;
        this.retentionSettings = retentionSettings == null ? Collections.emptyMap() : Collections.unmodifiableMap(retentionSettings);
    }

    public TenantDefinition(Tenant tenant) {
        this.id = tenant.getId();
        this.retentionSettings = tenant.getRetentionSettings();
    }

    @ApiModelProperty(value="Identifier of the tenant", required=true)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Retention settings for metrics, expressed in days")
    @JsonProperty(value="retentions")
    @org.codehaus.jackson.annotate.JsonProperty(value="retentions")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY, keyUsing=org.hawkular.metrics.api.jaxrs.fasterxml.jackson.MetricTypeKeySerializer.class)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY, keyUsing=MetricTypeKeySerializer.class)
    @JsonDeserialize(keyUsing=org.hawkular.metrics.api.jaxrs.codehaus.jackson.MetricTypeKeyDeserializer.class)
    public Map<MetricType<?>, Integer> getRetentionSettings() {
        return this.retentionSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantDefinition that = (TenantDefinition)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).omitNullValues().toString();
    }

    public Tenant toTenant() {
        return new Tenant(this.id, this.retentionSettings);
    }
}

