/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.api.jaxrs.model.CounterDataPoint;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import rx.Observable;

@ApiModel(description="A counter metric with one or more data points")
public class Counter {
    private final String id;
    private final List<CounterDataPoint> data;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @org.codehaus.jackson.annotate.JsonCreator
    public Counter(@JsonProperty(value="id") @org.codehaus.jackson.annotate.JsonProperty(value="id") String id, @JsonProperty(value="data") @org.codehaus.jackson.annotate.JsonProperty(value="data") List<CounterDataPoint> data) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Counter id is null");
        this.id = id;
        this.data = data == null || data.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(data);
    }

    @ApiModelProperty(value="Identifier of the metric", required=true)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Counter data points")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public List<CounterDataPoint> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Counter counter = (Counter)o;
        return this.id.equals(counter.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("data", this.data).omitNullValues().toString();
    }

    public static Observable<Metric<Long>> toObservable(String tenantId, List<Counter> counters) {
        return Observable.from(counters).map(c -> {
            List<DataPoint<Long>> dataPoints = CounterDataPoint.asDataPoints(c.getData());
            return new Metric(new MetricId(tenantId, MetricType.COUNTER, c.getId()), dataPoints);
        });
    }
}

