/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.api.jaxrs.fasterxml.jackson.MetricTypeDeserializer;
import org.hawkular.metrics.api.jaxrs.fasterxml.jackson.MetricTypeSerializer;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricType;

@ApiModel(value="Metric", description="The definition of a metric")
public class MetricDefinition {
    private final String tenantId;
    private final String id;
    private final Map<String, String> tags;
    private final Integer dataRetention;
    private final MetricType<?> type;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @org.codehaus.jackson.annotate.JsonCreator
    public MetricDefinition(@JsonProperty(value="id") @org.codehaus.jackson.annotate.JsonProperty(value="id") String id, @JsonProperty(value="tags") @org.codehaus.jackson.annotate.JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="dataRetention") @org.codehaus.jackson.annotate.JsonProperty(value="dataRetention") Integer dataRetention, @JsonProperty(value="type") @org.codehaus.jackson.annotate.JsonProperty(value="type") @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=MetricTypeDeserializer.class) @JsonDeserialize(using=org.hawkular.metrics.api.jaxrs.codehaus.jackson.MetricTypeDeserializer.class) MetricType<?> type) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Metric id is null");
        this.tenantId = null;
        this.id = id;
        this.tags = tags == null ? Collections.emptyMap() : Collections.unmodifiableMap(tags);
        this.dataRetention = dataRetention;
        this.type = type;
    }

    public MetricDefinition(Metric<?> metric) {
        this.tenantId = metric.getId().getTenantId();
        this.id = metric.getId().getName();
        this.type = metric.getId().getType();
        this.tags = metric.getTags();
        this.dataRetention = metric.getDataRetention();
    }

    @ApiModelProperty(value="Identifier of the tenant")
    public String getTenantId() {
        return this.tenantId;
    }

    @ApiModelProperty(value="Identifier of the metric", required=true)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Metric tags")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @ApiModelProperty(value="How long, in days, a data point of this metric stays in the system after it is stored")
    public Integer getDataRetention() {
        return this.dataRetention;
    }

    @ApiModelProperty(value="Metric type", dataType="string", allowableValues="gauge, availability, counter")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(using=MetricTypeSerializer.class)
    @JsonSerialize(using=org.hawkular.metrics.api.jaxrs.codehaus.jackson.MetricTypeSerializer.class)
    public MetricType<?> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDefinition that = (MetricDefinition)o;
        return this.id.equals(that.id) && this.type == that.type;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("id", (Object)this.id).add("tags", this.tags).add("dataRetention", (Object)this.dataRetention).add("type", this.type).omitNullValues().toString();
    }
}

