/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.api.jaxrs.model.AvailabilityDataPoint;
import org.hawkular.metrics.core.api.AvailabilityType;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import rx.Observable;

@ApiModel(description="An availability metric with one or more data points")
public class Availability {
    private final String id;
    private final List<AvailabilityDataPoint> data;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @org.codehaus.jackson.annotate.JsonCreator
    public Availability(@JsonProperty(value="id") @org.codehaus.jackson.annotate.JsonProperty(value="id") String id, @JsonProperty(value="data") @org.codehaus.jackson.annotate.JsonProperty(value="data") List<AvailabilityDataPoint> data) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Availability id is null");
        this.id = id;
        this.data = data == null || data.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(data);
    }

    @ApiModelProperty(value="Identifier of the metric", required=true)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Availability data points")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public List<AvailabilityDataPoint> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Availability that = (Availability)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("data", this.data).omitNullValues().toString();
    }

    public static Observable<Metric<AvailabilityType>> toObservable(String tenantId, List<Availability> availabilities) {
        return Observable.from(availabilities).map(c -> {
            List<DataPoint<AvailabilityType>> dataPoints = AvailabilityDataPoint.asDataPoints(c.getData());
            return new Metric(new MetricId(tenantId, MetricType.AVAILABILITY, c.getId()), dataPoints);
        });
    }
}

