/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hawkular.metrics.api.jaxrs.fasterxml.jackson.AvailabilityTypeSerializer;
import org.hawkular.metrics.core.api.AvailabilityType;
import org.hawkular.metrics.core.api.DataPoint;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import rx.Observable;

@ApiModel(description="Consists of a timestamp and a textual value indicating a system availability")
public class AvailabilityDataPoint {
    private final long timestamp;
    private final AvailabilityType value;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @org.codehaus.jackson.annotate.JsonCreator
    public AvailabilityDataPoint(@JsonProperty(value="timestamp") @org.codehaus.jackson.annotate.JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="value") @org.codehaus.jackson.annotate.JsonProperty(value="value") String value, @JsonProperty(value="tags") @org.codehaus.jackson.annotate.JsonProperty(value="tags") Map<String, String> tags) {
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"Data point timestamp is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Data point value is null");
        this.timestamp = timestamp;
        this.value = AvailabilityType.fromString((String)value);
    }

    public AvailabilityDataPoint(DataPoint<AvailabilityType> dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = (AvailabilityType)dataPoint.getValue();
    }

    @ApiModelProperty(required=true)
    public long getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=true, dataType="string", allowableValues="up,down,unknown")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(using=AvailabilityTypeSerializer.class)
    @JsonSerialize(using=org.hawkular.metrics.api.jaxrs.codehaus.jackson.AvailabilityTypeSerializer.class)
    public AvailabilityType getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailabilityDataPoint that = (AvailabilityDataPoint)o;
        return this.timestamp == that.timestamp && this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", (Object)this.value).omitNullValues().toString();
    }

    public static List<DataPoint<AvailabilityType>> asDataPoints(List<AvailabilityDataPoint> points) {
        return Lists.transform(points, p -> new DataPoint(p.getTimestamp(), (Object)p.getValue()));
    }

    public static Observable<Metric<AvailabilityType>> toObservable(String tenantId, String metricId, List<AvailabilityDataPoint> points) {
        List<DataPoint<AvailabilityType>> dataPoints = AvailabilityDataPoint.asDataPoints(points);
        Metric metric = new Metric(new MetricId(tenantId, MetricType.AVAILABILITY, metricId), dataPoints);
        return Observable.just((Object)metric);
    }
}

